define({ "api": [ {

    "type": "post",

    "url": "/group/add",

    "title": "Add Group.",

    "version": "0.1.0",

    "name": "AddGroup",

    "group": "Group",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-API-KEY",

            "description": "<p>Groups unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Groups unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Group Cant be Accessed permission name : api_group_add"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Name",

            "description": "<p>Mandatory name of Groups.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Definition",

            "description": "<p>Optional definition of Groups.</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "ValidationError",

            "description": "<p>Error validation.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Group.php",

    "groupTitle": "Group"

  },

  {

    "type": "get",

    "url": "/group/all",

    "title": "Get all groups.",

    "version": "0.1.0",

    "name": "AllGroup",

    "group": "Group",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-API-KEY",

            "description": "<p>Groups unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Groups unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Group Cant be Accessed permission name : api_group_all"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Filter",

            "defaultValue": "null",

            "description": "<p>Optional filter of Groups.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Field",

            "defaultValue": "All Field",

            "description": "<p>Optional field of Groups.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Start",

            "defaultValue": "0",

            "description": "<p>Optional start index of Groups.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Limit",

            "defaultValue": "10",

            "description": "<p>Optional limit data of Groups.</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "Array",

            "optional": false,

            "field": "Data",

            "description": "<p>data of group.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "NoDataGroup",

            "description": "<p>Group data is nothing.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Group.php",

    "groupTitle": "Group"

  },

  {

    "type": "post",

    "url": "/group/delete",

    "title": "Delete Group.",

    "version": "0.1.0",

    "name": "DeleteGroup",

    "group": "Group",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-API-KEY",

            "description": "<p>Groups unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Groups unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Group Cant be Accessed permission name : api_group_delete"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "Integer",

            "optional": false,

            "field": "Id",

            "description": "<p>Mandatory id of Groups .</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "ValidationError",

            "description": "<p>Error validation.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Group.php",

    "groupTitle": "Group"

  },

  {

    "type": "get",

    "url": "/group/detail",

    "title": "Detail Group.",

    "version": "0.1.0",

    "name": "DetailGroup",

    "group": "Group",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-API-KEY",

            "description": "<p>Groups unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Groups unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Group Cant be Accessed permission name : api_group_detail"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "Integer",

            "optional": false,

            "field": "Id",

            "description": "<p>Mandatory id of Groups.</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "Array",

            "optional": false,

            "field": "Data",

            "description": "<p>data of group.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "GroupNotFound",

            "description": "<p>Group data is not found.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Group.php",

    "groupTitle": "Group"

  },

  {

    "type": "post",

    "url": "/group/update",

    "title": "Update Group.",

    "version": "0.1.0",

    "name": "UpdateGroup",

    "group": "Group",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-API-KEY",

            "description": "<p>Groups unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Groups unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Group Cant be Accessed permission name : api_group_update"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Name",

            "description": "<p>Mandatory Name of Groups.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Definition",

            "description": "<p>Optional definition of Groups.</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "ValidationError",

            "description": "<p>Error validation.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Group.php",

    "groupTitle": "Group"

  },{
"type": "post",
"url": "/agritun_vente/add",
"title": "Add Agritun vente.",
"version": "0.1.0",
"name": "Addagritun_vente",
"group": "agritun_vente",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun vente unique access-key.</p>"
}
,
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun vente unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun vente Cant be Accessed permission name : api_agritun_vente_add"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Type_vente",
  "description": "<p>Mandatory type_vente of Agritun ventes Input Type Vente Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite",
  "description": "<p>Mandatory qualite of Agritun ventes Input Qualite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Quantite",
  "description": "<p>Mandatory quantite of Agritun ventes Input Quantite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Prix_u",
  "description": "<p>Mandatory prix_u of Agritun ventes Input Prix U Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Montant",
  "description": "<p>Mandatory montant of Agritun ventes Input Montant Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Acheteur",
  "description": "<p>Mandatory acheteur of Agritun ventes Input Acheteur Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Tel",
  "description": "<p>Mandatory tel of Agritun ventes Input Tel Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun ventes Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun ventes Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun ventes Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun_vente.php",
"groupTitle": "Agritun vente"
},
{
"type": "get",
"url": "/agritun_vente/all",
"title": "Get all Agritun ventes.",
"version": "0.1.0",
"name": "Allagritun_vente",
"group": "agritun_vente",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun ventes unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun ventes unique token.</p>"
}
]
}
},
"permission": [
{
"name": "{} Cant be Accessed permission name : api_Agritun vente_all"
}
],
"parameter": {
"fields": {
"Parameter": [


{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Field",
"defaultValue": "All Field",
"description": "<p>Optional field of Agritun ventes.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Start",
"defaultValue": "0",
"description": "<p>Optional start index of Agritun ventes.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Limit",
"defaultValue": "10",
"description": "<p>Optional limit data of Agritun ventes.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_field",
"defaultValue": "id",
"description": "<p>Sort data by this field. id, type_vente, qualite, quantite, prix_u, montant, acheteur, date, tel, i_src, user_id, id_parcel</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_order",
"defaultValue": "DESC",
"description": "<p>Sort data order this field ASC or DESC.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Filters",
"defaultValue": "",
"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun vente.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "NoDataAgritun vente",
"description": "<p>Agritun vente data is nothing.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun vente.php",
"groupTitle": "Agritun vente"
},
{
"type": "post",
"url": "/agritun_vente/delete",
"title": "Delete Agritun vente.",
"version": "0.1.0",
"name": "Deleteagritun_vente",
"group": "agritun_vente",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun ventes unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun ventes unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun vente Cant be Accessed permission name : api_Agritun vente_delete"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun ventes .</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun vente.php",
"groupTitle": "Agritun vente"
},
{
"type": "get",
"url": "/agritun_vente/detail",
"title": "Detail Agritun vente.",
"version": "0.1.0",
"name": "Detailagritun_vente",
"group": "agritun_vente",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun ventes unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun ventes unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun vente Cant be Accessed permission name : api_Agritun vente_detail"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun ventes.</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun vente.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "Agritun venteNotFound",
"description": "<p>Agritun vente data is not found.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun vente.php",
"groupTitle": "Agritun vente"
},
{
"type": "post",
"url": "/agritun_vente/update",
"title": "Update Agritun vente.",
"version": "0.1.0",
"name": "Updateagritun_vente",
"group": "agritun_vente",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun ventes unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun ventes unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun vente Cant be Accessed permission name : api_Agritun vente_update"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Type_vente",
  "description": "<p>Mandatory type_vente of Agritun ventes Input Type Vente Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite",
  "description": "<p>Mandatory qualite of Agritun ventes Input Qualite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Quantite",
  "description": "<p>Mandatory quantite of Agritun ventes Input Quantite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Prix_u",
  "description": "<p>Mandatory prix_u of Agritun ventes Input Prix U Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Montant",
  "description": "<p>Mandatory montant of Agritun ventes Input Montant Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Acheteur",
  "description": "<p>Mandatory acheteur of Agritun ventes Input Acheteur Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Tel",
  "description": "<p>Mandatory tel of Agritun ventes Input Tel Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun ventes Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun ventes Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun ventes Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun vente.php",
"groupTitle": "Agritun vente"
},{


"type": "post",


"url": "/agritun_recolte/add",


"title": "Add Agritun recolte.",


"version": "0.1.0",


"name": "Addagritun_recolte",


"group": "agritun_recolte",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun recolte unique access-key.</p>"


}


,


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun recolte unique token.</p>"


}




]


}


},


"permission": [


{


"name": "Agritun recolte Cant be Accessed permission name : api_agritun_recolte_add"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Id_parcel",


  "description": "<p>Mandatory id_parcel of Agritun recoltes Input Id Parcel Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Id_equipe",


  "description": "<p>Mandatory id_equipe of Agritun recoltes Input Id Equipe Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Id_utilisateur",


  "description": "<p>Mandatory id_utilisateur of Agritun recoltes Input Id Utilisateur Max Length : 11..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_paiement",


  "description": "<p>Mandatory mode_paiement of Agritun recoltes Input Mode Paiement Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nbr_pieds",


  "description": "<p>Mandatory nbr_pieds of Agritun recoltes Input Nbr Pieds Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Hay",


  "description": "<p>Mandatory hay of Agritun recoltes Input Hay Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nchira",


  "description": "<p>Mandatory nchira of Agritun recoltes Input Nchira Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Q_unite",


  "description": "<p>Optional q_unite of Agritun recoltes Input Q Unite Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Q_prix",


  "description": "<p>Optional q_prix of Agritun recoltes Input Q Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_prix",


  "description": "<p>Optional h_prix of Agritun recoltes Input H Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_prix",


  "description": "<p>Optional f_prix of Agritun recoltes Input F Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_nbr",


  "description": "<p>Optional h_nbr of Agritun recoltes Input H Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_nbr",


  "description": "<p>Optional f_nbr of Agritun recoltes Input F Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Cout",


  "description": "<p>Mandatory cout of Agritun recoltes .</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "I_src",


  "description": "<p>Mandatory i_src of Agritun recoltes Input I Src Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun recoltes Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun_recolte.php",


"groupTitle": "Agritun recolte"


},


{


"type": "get",


"url": "/agritun_recolte/all",


"title": "Get all Agritun recoltes.",


"version": "0.1.0",


"name": "Allagritun_recolte",


"group": "agritun_recolte",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun recoltes unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun recoltes unique token.</p>"


}


]


}


},


"permission": [


{


"name": "{} Cant be Accessed permission name : api_Agritun recolte_all"


}


],


"parameter": {


"fields": {


"Parameter": [








{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Field",


"defaultValue": "All Field",


"description": "<p>Optional field of Agritun recoltes.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Start",


"defaultValue": "0",


"description": "<p>Optional start index of Agritun recoltes.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Limit",


"defaultValue": "10",


"description": "<p>Optional limit data of Agritun recoltes.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_field",


"defaultValue": "id",


"description": "<p>Sort data by this field. id, date, id_parcel, id_equipe, id_utilisateur, mode_paiement, nbr_pieds, hay, nchira, q_unite, q_prix, h_prix, f_prix, h_nbr, f_nbr, cout, i_src, user_id</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_order",


"defaultValue": "DESC",


"description": "<p>Sort data order this field ASC or DESC.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Filters",


"defaultValue": "",


"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun recolte.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "NoDataAgritun recolte",


"description": "<p>Agritun recolte data is nothing.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun recolte.php",


"groupTitle": "Agritun recolte"


},


{


"type": "post",


"url": "/agritun_recolte/delete",


"title": "Delete Agritun recolte.",


"version": "0.1.0",


"name": "Deleteagritun_recolte",


"group": "agritun_recolte",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun recoltes unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun recoltes unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun recolte Cant be Accessed permission name : api_Agritun recolte_delete"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun recoltes .</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun recolte.php",


"groupTitle": "Agritun recolte"


},


{


"type": "get",


"url": "/agritun_recolte/detail",


"title": "Detail Agritun recolte.",


"version": "0.1.0",


"name": "Detailagritun_recolte",


"group": "agritun_recolte",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun recoltes unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun recoltes unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun recolte Cant be Accessed permission name : api_Agritun recolte_detail"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun recoltes.</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun recolte.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "Agritun recolteNotFound",


"description": "<p>Agritun recolte data is not found.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun recolte.php",


"groupTitle": "Agritun recolte"


},


{


"type": "post",


"url": "/agritun_recolte/update",


"title": "Update Agritun recolte.",


"version": "0.1.0",


"name": "Updateagritun_recolte",


"group": "agritun_recolte",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun recoltes unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun recoltes unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun recolte Cant be Accessed permission name : api_Agritun recolte_update"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Id_parcel",


  "description": "<p>Mandatory id_parcel of Agritun recoltes Input Id Parcel Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Id_equipe",


  "description": "<p>Mandatory id_equipe of Agritun recoltes Input Id Equipe Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Id_utilisateur",


  "description": "<p>Mandatory id_utilisateur of Agritun recoltes Input Id Utilisateur Max Length : 11..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_paiement",


  "description": "<p>Mandatory mode_paiement of Agritun recoltes Input Mode Paiement Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nbr_pieds",


  "description": "<p>Mandatory nbr_pieds of Agritun recoltes Input Nbr Pieds Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Hay",


  "description": "<p>Mandatory hay of Agritun recoltes Input Hay Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nchira",


  "description": "<p>Mandatory nchira of Agritun recoltes Input Nchira Max Length : 100..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Q_unite",


  "description": "<p>Optional q_unite of Agritun recoltes Input Q Unite Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Q_prix",


  "description": "<p>Optional q_prix of Agritun recoltes Input Q Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_prix",


  "description": "<p>Optional h_prix of Agritun recoltes Input H Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_prix",


  "description": "<p>Optional f_prix of Agritun recoltes Input F Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_nbr",


  "description": "<p>Optional h_nbr of Agritun recoltes Input H Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_nbr",


  "description": "<p>Optional f_nbr of Agritun recoltes Input F Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Cout",


  "description": "<p>Mandatory cout of Agritun recoltes .</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "I_src",


  "description": "<p>Mandatory i_src of Agritun recoltes Input I Src Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun recoltes Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun recolte.php",


"groupTitle": "Agritun recolte"


},{

"type": "post",

"url": "/webvue_team_media/add",

"title": "Add Webvue team media.",

"version": "0.1.0",

"name": "Addwebvue_team_media",

"group": "webvue_team_media",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue team media unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team media Cant be Accessed permission name : api_webvue_team_media_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Member_id",

  "description": "<p>Mandatory member_id of Webvue team medias Input Member Id Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue team medias Input Name Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue team medias .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Icon",

  "description": "<p>Mandatory icon of Webvue team medias Input Icon Max Length : 100..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_team_media.php",

"groupTitle": "Webvue team media"

},

{

"type": "get",

"url": "/webvue_team_media/all",

"title": "Get all Webvue team medias.",

"version": "0.1.0",

"name": "Allwebvue_team_media",

"group": "webvue_team_media",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue team medias unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue team medias unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue team media_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue team medias.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue team medias.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue team medias.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, member_id, name, link, icon</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue team media.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue team media",

"description": "<p>Webvue team media data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team media.php",

"groupTitle": "Webvue team media"

},

{

"type": "post",

"url": "/webvue_team_media/delete",

"title": "Delete Webvue team media.",

"version": "0.1.0",

"name": "Deletewebvue_team_media",

"group": "webvue_team_media",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue team medias unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue team medias unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team media Cant be Accessed permission name : api_Webvue team media_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue team medias .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team media.php",

"groupTitle": "Webvue team media"

},

{

"type": "get",

"url": "/webvue_team_media/detail",

"title": "Detail Webvue team media.",

"version": "0.1.0",

"name": "Detailwebvue_team_media",

"group": "webvue_team_media",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue team medias unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue team medias unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team media Cant be Accessed permission name : api_Webvue team media_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue team medias.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue team media.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue team mediaNotFound",

"description": "<p>Webvue team media data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team media.php",

"groupTitle": "Webvue team media"

},

{

"type": "post",

"url": "/webvue_team_media/update",

"title": "Update Webvue team media.",

"version": "0.1.0",

"name": "Updatewebvue_team_media",

"group": "webvue_team_media",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue team medias unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue team medias unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team media Cant be Accessed permission name : api_Webvue team media_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Member_id",

  "description": "<p>Mandatory member_id of Webvue team medias Input Member Id Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue team medias Input Name Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue team medias .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Icon",

  "description": "<p>Mandatory icon of Webvue team medias Input Icon Max Length : 100..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team media.php",

"groupTitle": "Webvue team media"

},{

"type": "post",

"url": "/services/add",

"title": "Add Services.",

"version": "0.1.0",

"name": "Addservices",

"group": "services",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Services unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Services Cant be Accessed permission name : api_services_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Icon",

  "description": "<p>Mandatory icon of Servicess Input Icon Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Servicess Input Name Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Servicess .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Color",

  "description": "<p>Mandatory color of Servicess Input Color Max Length : 10..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Services.php",

"groupTitle": "Services"

},

{

"type": "get",

"url": "/services/all",

"title": "Get all Servicess.",

"version": "0.1.0",

"name": "Allservices",

"group": "services",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Servicess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Servicess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Services_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Servicess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Servicess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Servicess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, icon, name, description, color</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Services.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataServices",

"description": "<p>Services data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Services.php",

"groupTitle": "Services"

},

{

"type": "post",

"url": "/services/delete",

"title": "Delete Services.",

"version": "0.1.0",

"name": "Deleteservices",

"group": "services",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Servicess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Servicess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Services Cant be Accessed permission name : api_Services_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Servicess .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Services.php",

"groupTitle": "Services"

},

{

"type": "get",

"url": "/services/detail",

"title": "Detail Services.",

"version": "0.1.0",

"name": "Detailservices",

"group": "services",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Servicess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Servicess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Services Cant be Accessed permission name : api_Services_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Servicess.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Services.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ServicesNotFound",

"description": "<p>Services data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Services.php",

"groupTitle": "Services"

},

{

"type": "post",

"url": "/services/update",

"title": "Update Services.",

"version": "0.1.0",

"name": "Updateservices",

"group": "services",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Servicess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Servicess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Services Cant be Accessed permission name : api_Services_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Icon",

  "description": "<p>Mandatory icon of Servicess Input Icon Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Servicess Input Name Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Servicess .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Color",

  "description": "<p>Mandatory color of Servicess Input Color Max Length : 10..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Services.php",

"groupTitle": "Services"

},{

"type": "post",

"url": "/webvue_strategies/add",

"title": "Add Webvue strategies.",

"version": "0.1.0",

"name": "Addwebvue_strategies",

"group": "webvue_strategies",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategies unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies Cant be Accessed permission name : api_webvue_strategies_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue strategiess .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_strategies.php",

"groupTitle": "Webvue strategies"

},

{

"type": "get",

"url": "/webvue_strategies/all",

"title": "Get all Webvue strategiess.",

"version": "0.1.0",

"name": "Allwebvue_strategies",

"group": "webvue_strategies",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategiess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategiess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue strategies_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue strategiess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue strategiess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue strategiess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, img_url</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue strategies.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue strategies",

"description": "<p>Webvue strategies data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies.php",

"groupTitle": "Webvue strategies"

},

{

"type": "post",

"url": "/webvue_strategies/delete",

"title": "Delete Webvue strategies.",

"version": "0.1.0",

"name": "Deletewebvue_strategies",

"group": "webvue_strategies",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategiess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategiess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies Cant be Accessed permission name : api_Webvue strategies_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue strategiess .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies.php",

"groupTitle": "Webvue strategies"

},

{

"type": "get",

"url": "/webvue_strategies/detail",

"title": "Detail Webvue strategies.",

"version": "0.1.0",

"name": "Detailwebvue_strategies",

"group": "webvue_strategies",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategiess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategiess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies Cant be Accessed permission name : api_Webvue strategies_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue strategiess.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue strategies.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue strategiesNotFound",

"description": "<p>Webvue strategies data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies.php",

"groupTitle": "Webvue strategies"

},

{

"type": "post",

"url": "/webvue_strategies/update",

"title": "Update Webvue strategies.",

"version": "0.1.0",

"name": "Updatewebvue_strategies",

"group": "webvue_strategies",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategiess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategiess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies Cant be Accessed permission name : api_Webvue strategies_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue strategiess .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies.php",

"groupTitle": "Webvue strategies"

},{


"type": "post",


"url": "/agritun_team/add",


"title": "Add Agritun team.",


"version": "0.1.0",


"name": "Addagritun_team",


"group": "agritun_team",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun team unique access-key.</p>"


}


,


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun team unique token.</p>"


}




]


}


},


"permission": [


{


"name": "Agritun team Cant be Accessed permission name : api_agritun_team_add"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Team_name",


  "description": "<p>Mandatory team_name of Agritun teams Input Team Name Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_paiement",


  "description": "<p>Mandatory mode_paiement of Agritun teams Input Mode Paiement Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_prix",


  "description": "<p>Optional h_prix of Agritun teams Input H Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_prix",


  "description": "<p>Optional f_prix of Agritun teams Input F Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_nbr",


  "description": "<p>Optional h_nbr of Agritun teams Input H Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_nbr",


  "description": "<p>Optional f_nbr of Agritun teams Input F Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Q_unite",


  "description": "<p>Mandatory q_unite of Agritun teams Input Q Unite Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Q_prix",


  "description": "<p>Optional q_prix of Agritun teams Input Q Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_culture",


  "description": "<p>Mandatory mode_culture of Agritun teams Input Mode Culture Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Tel",


  "description": "<p>Mandatory tel of Agritun teams Input Tel Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun teams Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun_team.php",


"groupTitle": "Agritun team"


},


{


"type": "get",


"url": "/agritun_team/all",


"title": "Get all Agritun teams.",


"version": "0.1.0",


"name": "Allagritun_team",


"group": "agritun_team",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun teams unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun teams unique token.</p>"


}


]


}


},


"permission": [


{


"name": "{} Cant be Accessed permission name : api_Agritun team_all"


}


],


"parameter": {


"fields": {


"Parameter": [








{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Field",


"defaultValue": "All Field",


"description": "<p>Optional field of Agritun teams.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Start",


"defaultValue": "0",


"description": "<p>Optional start index of Agritun teams.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Limit",


"defaultValue": "10",


"description": "<p>Optional limit data of Agritun teams.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_field",


"defaultValue": "id",


"description": "<p>Sort data by this field. id, team_name, mode_paiement, h_prix, f_prix, h_nbr, f_nbr, q_unite, q_prix, mode_culture, tel, user_id</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_order",


"defaultValue": "DESC",


"description": "<p>Sort data order this field ASC or DESC.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Filters",


"defaultValue": "",


"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun team.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "NoDataAgritun team",


"description": "<p>Agritun team data is nothing.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun team.php",


"groupTitle": "Agritun team"


},


{


"type": "post",


"url": "/agritun_team/delete",


"title": "Delete Agritun team.",


"version": "0.1.0",


"name": "Deleteagritun_team",


"group": "agritun_team",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun teams unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun teams unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun team Cant be Accessed permission name : api_Agritun team_delete"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun teams .</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun team.php",


"groupTitle": "Agritun team"


},


{


"type": "get",


"url": "/agritun_team/detail",


"title": "Detail Agritun team.",


"version": "0.1.0",


"name": "Detailagritun_team",


"group": "agritun_team",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun teams unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun teams unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun team Cant be Accessed permission name : api_Agritun team_detail"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun teams.</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun team.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "Agritun teamNotFound",


"description": "<p>Agritun team data is not found.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun team.php",


"groupTitle": "Agritun team"


},


{


"type": "post",


"url": "/agritun_team/update",


"title": "Update Agritun team.",


"version": "0.1.0",


"name": "Updateagritun_team",


"group": "agritun_team",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun teams unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun teams unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun team Cant be Accessed permission name : api_Agritun team_update"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Team_name",


  "description": "<p>Mandatory team_name of Agritun teams Input Team Name Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_paiement",


  "description": "<p>Mandatory mode_paiement of Agritun teams Input Mode Paiement Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_prix",


  "description": "<p>Optional h_prix of Agritun teams Input H Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_prix",


  "description": "<p>Optional f_prix of Agritun teams Input F Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "H_nbr",


  "description": "<p>Optional h_nbr of Agritun teams Input H Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "F_nbr",


  "description": "<p>Optional f_nbr of Agritun teams Input F Nbr Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Q_unite",


  "description": "<p>Mandatory q_unite of Agritun teams Input Q Unite Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Q_prix",


  "description": "<p>Optional q_prix of Agritun teams Input Q Prix Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_culture",


  "description": "<p>Mandatory mode_culture of Agritun teams Input Mode Culture Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Tel",


  "description": "<p>Mandatory tel of Agritun teams Input Tel Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun teams Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun team.php",


"groupTitle": "Agritun team"


},{

"type": "post",

"url": "/webvue_works_cat/add",

"title": "Add Webvue works cat.",

"version": "0.1.0",

"name": "Addwebvue_works_cat",

"group": "webvue_works_cat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue works cat unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works cat Cant be Accessed permission name : api_webvue_works_cat_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue works cats Input Name Max Length : 300..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_works_cat.php",

"groupTitle": "Webvue works cat"

},

{

"type": "get",

"url": "/webvue_works_cat/all",

"title": "Get all Webvue works cats.",

"version": "0.1.0",

"name": "Allwebvue_works_cat",

"group": "webvue_works_cat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue works cats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue works cats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue works cat_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue works cats.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue works cats.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue works cats.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, name</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue works cat.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue works cat",

"description": "<p>Webvue works cat data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works cat.php",

"groupTitle": "Webvue works cat"

},

{

"type": "post",

"url": "/webvue_works_cat/delete",

"title": "Delete Webvue works cat.",

"version": "0.1.0",

"name": "Deletewebvue_works_cat",

"group": "webvue_works_cat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue works cats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue works cats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works cat Cant be Accessed permission name : api_Webvue works cat_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue works cats .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works cat.php",

"groupTitle": "Webvue works cat"

},

{

"type": "get",

"url": "/webvue_works_cat/detail",

"title": "Detail Webvue works cat.",

"version": "0.1.0",

"name": "Detailwebvue_works_cat",

"group": "webvue_works_cat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue works cats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue works cats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works cat Cant be Accessed permission name : api_Webvue works cat_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue works cats.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue works cat.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue works catNotFound",

"description": "<p>Webvue works cat data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works cat.php",

"groupTitle": "Webvue works cat"

},

{

"type": "post",

"url": "/webvue_works_cat/update",

"title": "Update Webvue works cat.",

"version": "0.1.0",

"name": "Updatewebvue_works_cat",

"group": "webvue_works_cat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue works cats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue works cats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works cat Cant be Accessed permission name : api_Webvue works cat_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue works cats Input Name Max Length : 300..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works cat.php",

"groupTitle": "Webvue works cat"

},{

"type": "post",

"url": "/webvue_stat/add",

"title": "Add Webvue stat.",

"version": "0.1.0",

"name": "Addwebvue_stat",

"group": "webvue_stat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue stat unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue stat Cant be Accessed permission name : api_webvue_stat_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Icon",

  "description": "<p>Mandatory icon of Webvue stats Input Icon Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory title of Webvue stats Input Title Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Color",

  "description": "<p>Mandatory color of Webvue stats Input Color Max Length : 10..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Number",

  "description": "<p>Mandatory number of Webvue stats Input Number Max Length : 10..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_stat.php",

"groupTitle": "Webvue stat"

},

{

"type": "get",

"url": "/webvue_stat/all",

"title": "Get all Webvue stats.",

"version": "0.1.0",

"name": "Allwebvue_stat",

"group": "webvue_stat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue stats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue stats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue stat_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue stats.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue stats.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue stats.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, icon, title, color, number</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue stat.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue stat",

"description": "<p>Webvue stat data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue stat.php",

"groupTitle": "Webvue stat"

},

{

"type": "post",

"url": "/webvue_stat/delete",

"title": "Delete Webvue stat.",

"version": "0.1.0",

"name": "Deletewebvue_stat",

"group": "webvue_stat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue stats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue stats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue stat Cant be Accessed permission name : api_Webvue stat_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue stats .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue stat.php",

"groupTitle": "Webvue stat"

},

{

"type": "get",

"url": "/webvue_stat/detail",

"title": "Detail Webvue stat.",

"version": "0.1.0",

"name": "Detailwebvue_stat",

"group": "webvue_stat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue stats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue stats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue stat Cant be Accessed permission name : api_Webvue stat_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue stats.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue stat.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue statNotFound",

"description": "<p>Webvue stat data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue stat.php",

"groupTitle": "Webvue stat"

},

{

"type": "post",

"url": "/webvue_stat/update",

"title": "Update Webvue stat.",

"version": "0.1.0",

"name": "Updatewebvue_stat",

"group": "webvue_stat",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue stats unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue stats unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue stat Cant be Accessed permission name : api_Webvue stat_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Icon",

  "description": "<p>Mandatory icon of Webvue stats Input Icon Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory title of Webvue stats Input Title Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Color",

  "description": "<p>Mandatory color of Webvue stats Input Color Max Length : 10..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Number",

  "description": "<p>Mandatory number of Webvue stats Input Number Max Length : 10..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue stat.php",

"groupTitle": "Webvue stat"

},{
"type": "post",
"url": "/agritun_masra_entrant/add",
"title": "Add Agritun masra entrant.",
"version": "0.1.0",
"name": "Addagritun_masra_entrant",
"group": "agritun_masra_entrant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra entrant unique access-key.</p>"
}
,
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra entrant unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra entrant Cant be Accessed permission name : api_agritun_masra_entrant_add"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Masra",
  "description": "<p>Mandatory masra of Agritun masra entrants Input Masra Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite",
  "description": "<p>Mandatory qualite of Agritun masra entrants Input Qualite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Quantite",
  "description": "<p>Mandatory quantite of Agritun masra entrants Input Quantite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun masra entrants Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun masra entrants Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun masra entrants Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun_masra_entrant.php",
"groupTitle": "Agritun masra entrant"
},
{
"type": "get",
"url": "/agritun_masra_entrant/all",
"title": "Get all Agritun masra entrants.",
"version": "0.1.0",
"name": "Allagritun_masra_entrant",
"group": "agritun_masra_entrant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra entrants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra entrants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "{} Cant be Accessed permission name : api_Agritun masra entrant_all"
}
],
"parameter": {
"fields": {
"Parameter": [


{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Field",
"defaultValue": "All Field",
"description": "<p>Optional field of Agritun masra entrants.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Start",
"defaultValue": "0",
"description": "<p>Optional start index of Agritun masra entrants.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Limit",
"defaultValue": "10",
"description": "<p>Optional limit data of Agritun masra entrants.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_field",
"defaultValue": "id",
"description": "<p>Sort data by this field. id, masra, qualite, quantite, date, i_src, user_id, id_parcel</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_order",
"defaultValue": "DESC",
"description": "<p>Sort data order this field ASC or DESC.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Filters",
"defaultValue": "",
"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun masra entrant.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "NoDataAgritun masra entrant",
"description": "<p>Agritun masra entrant data is nothing.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra entrant.php",
"groupTitle": "Agritun masra entrant"
},
{
"type": "post",
"url": "/agritun_masra_entrant/delete",
"title": "Delete Agritun masra entrant.",
"version": "0.1.0",
"name": "Deleteagritun_masra_entrant",
"group": "agritun_masra_entrant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra entrants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra entrants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra entrant Cant be Accessed permission name : api_Agritun masra entrant_delete"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun masra entrants .</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra entrant.php",
"groupTitle": "Agritun masra entrant"
},
{
"type": "get",
"url": "/agritun_masra_entrant/detail",
"title": "Detail Agritun masra entrant.",
"version": "0.1.0",
"name": "Detailagritun_masra_entrant",
"group": "agritun_masra_entrant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra entrants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra entrants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra entrant Cant be Accessed permission name : api_Agritun masra entrant_detail"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun masra entrants.</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun masra entrant.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "Agritun masra entrantNotFound",
"description": "<p>Agritun masra entrant data is not found.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra entrant.php",
"groupTitle": "Agritun masra entrant"
},
{
"type": "post",
"url": "/agritun_masra_entrant/update",
"title": "Update Agritun masra entrant.",
"version": "0.1.0",
"name": "Updateagritun_masra_entrant",
"group": "agritun_masra_entrant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra entrants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra entrants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra entrant Cant be Accessed permission name : api_Agritun masra entrant_update"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Masra",
  "description": "<p>Mandatory masra of Agritun masra entrants Input Masra Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite",
  "description": "<p>Mandatory qualite of Agritun masra entrants Input Qualite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Quantite",
  "description": "<p>Mandatory quantite of Agritun masra entrants Input Quantite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun masra entrants Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun masra entrants Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun masra entrants Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra entrant.php",
"groupTitle": "Agritun masra entrant"
},{

  "type": "post",

  "url": "/user/add",

  "title": "Add User.",

  "version": "0.1.0",

  "name": "AddUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_add"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Username",

          "description": "<p>Mandatory username of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Email",

          "description": "<p>Mandatory email of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Password",

          "description": "<p>password of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "Array",

          "optional": true,

          "field": "Group",

          "defaultValue": "Default",

          "description": "<p>Optional group of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "File",

          "optional": true,

          "field": "Avatar",

          "defaultValue": "Default.PNG",

          "description": "<p>Optional avatar of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "ValidationError",

          "description": "<p>Error validation.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "get",

  "url": "/user/all",

  "title": "Get all users.",

  "version": "0.1.0",

  "name": "AllUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_all"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": true,

          "field": "Filter",

          "defaultValue": "null",

          "description": "<p>Optional filter of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": true,

          "field": "Field",

          "defaultValue": "All Field",

          "description": "<p>Optional field of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": true,

          "field": "Start",

          "defaultValue": "0",

          "description": "<p>Optional start index of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": true,

          "field": "Limit",

          "defaultValue": "10",

          "description": "<p>Optional limit data of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "Array",

          "optional": false,

          "field": "Data",

          "description": "<p>data of user.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "NoDataUser",

          "description": "<p>User data is nothing.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/delete",

  "title": "Delete User.",

  "version": "0.1.0",

  "name": "DeleteUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_delete"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "Integer",

          "optional": false,

          "field": "Id",

          "description": "<p>mandatory id of Users .</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "ValidationError",

          "description": "<p>Error validation.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "get",

  "url": "/user/detail",

  "title": "Detail User.",

  "version": "0.1.0",

  "name": "DetailUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_detail"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "Integer",

          "optional": false,

          "field": "Id",

          "description": "<p>Mandatory id of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "Array",

          "optional": false,

          "field": "Data",

          "description": "<p>data of user.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "UserNotFound",

          "description": "<p>User data is not found.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/login",

  "title": "User login authentication.",

  "version": "0.1.0",

  "name": "LoginUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "none"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Username",

          "description": "<p>Mandatory username of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Password",

          "description": "<p>Mandatory password of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "Array",

          "optional": false,

          "field": "Data",

          "description": "<p>data of user.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Token",

          "description": "<p>token for access api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "InvalidCredential",

          "description": "<p>The username or password is invalid.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/request_token",

  "title": "User request token.",

  "version": "0.1.0",

  "name": "RequestTokenUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "none"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Username",

          "description": "<p>Mandatory username of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Password",

          "description": "<p>Mandatory password of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Token",

          "description": "<p>token for access api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "InvalidCredential",

          "description": "<p>The username or password is invalid.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "get",

  "url": "/user/profile",

  "title": "Profile User.",

  "version": "0.1.0",

  "name": "ProfileUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_profile"

    }

  ],

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "Array",

          "optional": false,

          "field": "Data",

          "description": "<p>data of user.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "UserNotFound",

          "description": "<p>User data is not found.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/update_profile",

  "title": "Update Profile User.",

  "version": "0.1.0",

  "name": "UpdateProfileUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_update"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Email",

          "description": "<p>Mandatory email of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Password",

          "description": "<p>password of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "File",

          "optional": true,

          "field": "Avatar",

          "defaultValue": "Default.PNG",

          "description": "<p>Optional avatar of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "ValidationError",

          "description": "<p>Error validation.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/update",

  "title": "Update User.",

  "version": "0.1.0",

  "name": "UpdateUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_update"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Email",

          "description": "<p>Mandatory email of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Password",

          "description": "<p>password of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "Array",

          "optional": true,

          "field": "Group",

          "defaultValue": "Default",

          "description": "<p>Optional group of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "File",

          "optional": true,

          "field": "Avatar",

          "defaultValue": "Default.PNG",

          "description": "<p>Optional avatar of Users.</p>"

        },

        {

          "group": "Parameter",

          "type": "Integer",

          "optional": false,

          "field": "Id",

          "description": "<p>Mandatory id of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "ValidationError",

          "description": "<p>Error validation.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/remind_password",

  "title": "Update Remind password.",

  "version": "0.1.0",

  "name": "RemindPasswordUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_update"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Email",

          "description": "<p>Mandatory email of Users.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "ValidationError",

          "description": "<p>Error validation.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},

{

  "type": "post",

  "url": "/user/reset_password",

  "title": "Update Reset Password.",

  "version": "0.1.0",

  "name": "ResetPasswordUser",

  "group": "User",

  "header": {

    "fields": {

      "Header": [

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-API-KEY",

          "description": "<p>Users unique access-key.</p>"

        },

        {

          "group": "Header",

          "type": "String",

          "optional": false,

          "field": "X-Token",

          "description": "<p>Users unique token.</p>"

        }

      ]

    }

  },

  "permission": [

    {

      "name": "Group Cant be Accessed permission name : api_user_update"

    }

  ],

  "parameter": {

    "fields": {

      "Parameter": [

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "Reset_token",

          "description": "<p>Token from e-mail.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "password",

          "description": "<p>New password.</p>"

        },

        {

          "group": "Parameter",

          "type": "String",

          "optional": false,

          "field": "password_confirmation",

          "description": "<p>New password confirmation.</p>"

        }

      ]

    }

  },

  "success": {

    "fields": {

      "Success 200": [

        {

          "group": "Success 200",

          "type": "Boolean",

          "optional": false,

          "field": "Status",

          "description": "<p>status response api.</p>"

        },

        {

          "group": "Success 200",

          "type": "String",

          "optional": false,

          "field": "Message",

          "description": "<p>message response api.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Success-Response:",

        "content": "HTTP/1.1 200 OK",

        "type": "json"

      }

    ]

  },

  "error": {

    "fields": {

      "Error 4xx": [

        {

          "group": "Error 4xx",

          "optional": false,

          "field": "ValidationError",

          "description": "<p>Error validation.</p>"

        }

      ]

    },

    "examples": [

      {

        "title": "Error-Response:",

        "content": "HTTP/1.1 403 Not Acceptable",

        "type": "json"

      }

    ]

  },

  "filename": "application/controllers/api/User.php",

  "groupTitle": "User"

},{

"type": "post",

"url": "/webvue_strategies_details/add",

"title": "Add Webvue strategies details.",

"version": "0.1.0",

"name": "Addwebvue_strategies_details",

"group": "webvue_strategies_details",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategies details unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies details Cant be Accessed permission name : api_webvue_strategies_details_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue strategies detailss Input Name Max Length : 400..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_strategies_details.php",

"groupTitle": "Webvue strategies details"

},

{

"type": "get",

"url": "/webvue_strategies_details/all",

"title": "Get all Webvue strategies detailss.",

"version": "0.1.0",

"name": "Allwebvue_strategies_details",

"group": "webvue_strategies_details",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategies detailss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategies detailss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue strategies details_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue strategies detailss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue strategies detailss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue strategies detailss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, name</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue strategies details.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue strategies details",

"description": "<p>Webvue strategies details data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies details.php",

"groupTitle": "Webvue strategies details"

},

{

"type": "post",

"url": "/webvue_strategies_details/delete",

"title": "Delete Webvue strategies details.",

"version": "0.1.0",

"name": "Deletewebvue_strategies_details",

"group": "webvue_strategies_details",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategies detailss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategies detailss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies details Cant be Accessed permission name : api_Webvue strategies details_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue strategies detailss .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies details.php",

"groupTitle": "Webvue strategies details"

},

{

"type": "get",

"url": "/webvue_strategies_details/detail",

"title": "Detail Webvue strategies details.",

"version": "0.1.0",

"name": "Detailwebvue_strategies_details",

"group": "webvue_strategies_details",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategies detailss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategies detailss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies details Cant be Accessed permission name : api_Webvue strategies details_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue strategies detailss.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue strategies details.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue strategies detailsNotFound",

"description": "<p>Webvue strategies details data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies details.php",

"groupTitle": "Webvue strategies details"

},

{

"type": "post",

"url": "/webvue_strategies_details/update",

"title": "Update Webvue strategies details.",

"version": "0.1.0",

"name": "Updatewebvue_strategies_details",

"group": "webvue_strategies_details",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue strategies detailss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue strategies detailss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue strategies details Cant be Accessed permission name : api_Webvue strategies details_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue strategies detailss Input Name Max Length : 400..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue strategies details.php",

"groupTitle": "Webvue strategies details"

},{

"type": "post",

"url": "/webvue_pages/add",

"title": "Add Webvue pages.",

"version": "0.1.0",

"name": "Addwebvue_pages",

"group": "webvue_pages",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue pages unique access-key.</p>"

}

,

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue pages unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue pages Cant be Accessed permission name : api_webvue_pages_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Subtitle",

  "description": "<p>Mandatory Subtitle of Webvue pagess Input Subtitle Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory Title of Webvue pagess Input Title Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Content",

  "description": "<p>Mandatory Content of Webvue pagess .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_pages.php",

"groupTitle": "Webvue pages"

},

{

"type": "get",

"url": "/webvue_pages/all",

"title": "Get all Webvue pagess.",

"version": "0.1.0",

"name": "Allwebvue_pages",

"group": "webvue_pages",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue pagess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue pagess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue pages_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue pagess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue pagess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue pagess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, Subtitle, Title, Content</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue pages.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue pages",

"description": "<p>Webvue pages data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue pages.php",

"groupTitle": "Webvue pages"

},

{

"type": "post",

"url": "/webvue_pages/delete",

"title": "Delete Webvue pages.",

"version": "0.1.0",

"name": "Deletewebvue_pages",

"group": "webvue_pages",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue pagess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue pagess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue pages Cant be Accessed permission name : api_Webvue pages_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue pagess .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue pages.php",

"groupTitle": "Webvue pages"

},

{

"type": "get",

"url": "/webvue_pages/detail",

"title": "Detail Webvue pages.",

"version": "0.1.0",

"name": "Detailwebvue_pages",

"group": "webvue_pages",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue pagess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue pagess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue pages Cant be Accessed permission name : api_Webvue pages_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue pagess.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue pages.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue pagesNotFound",

"description": "<p>Webvue pages data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue pages.php",

"groupTitle": "Webvue pages"

},

{

"type": "post",

"url": "/webvue_pages/update",

"title": "Update Webvue pages.",

"version": "0.1.0",

"name": "Updatewebvue_pages",

"group": "webvue_pages",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue pagess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue pagess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue pages Cant be Accessed permission name : api_Webvue pages_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Subtitle",

  "description": "<p>Mandatory Subtitle of Webvue pagess Input Subtitle Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory Title of Webvue pagess Input Title Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Content",

  "description": "<p>Mandatory Content of Webvue pagess .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue pages.php",

"groupTitle": "Webvue pages"

},{

"type": "post",

"url": "/webvue_apropos/add",

"title": "Add Webvue apropos.",

"version": "0.1.0",

"name": "Addwebvue_apropos",

"group": "webvue_apropos",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue apropos unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue apropos Cant be Accessed permission name : api_webvue_apropos_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory title of Webvue aproposs Input Title Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Webvue aproposs .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue aproposs .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_apropos.php",

"groupTitle": "Webvue apropos"

},

{

"type": "get",

"url": "/webvue_apropos/all",

"title": "Get all Webvue aproposs.",

"version": "0.1.0",

"name": "Allwebvue_apropos",

"group": "webvue_apropos",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue aproposs unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue aproposs unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue apropos_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue aproposs.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue aproposs.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue aproposs.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, title, description, img_url</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue apropos.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue apropos",

"description": "<p>Webvue apropos data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue apropos.php",

"groupTitle": "Webvue apropos"

},

{

"type": "post",

"url": "/webvue_apropos/delete",

"title": "Delete Webvue apropos.",

"version": "0.1.0",

"name": "Deletewebvue_apropos",

"group": "webvue_apropos",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue aproposs unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue aproposs unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue apropos Cant be Accessed permission name : api_Webvue apropos_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue aproposs .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue apropos.php",

"groupTitle": "Webvue apropos"

},

{

"type": "get",

"url": "/webvue_apropos/detail",

"title": "Detail Webvue apropos.",

"version": "0.1.0",

"name": "Detailwebvue_apropos",

"group": "webvue_apropos",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue aproposs unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue aproposs unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue apropos Cant be Accessed permission name : api_Webvue apropos_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue aproposs.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue apropos.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue aproposNotFound",

"description": "<p>Webvue apropos data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue apropos.php",

"groupTitle": "Webvue apropos"

},

{

"type": "post",

"url": "/webvue_apropos/update",

"title": "Update Webvue apropos.",

"version": "0.1.0",

"name": "Updatewebvue_apropos",

"group": "webvue_apropos",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue aproposs unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue aproposs unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue apropos Cant be Accessed permission name : api_Webvue apropos_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory title of Webvue aproposs Input Title Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Webvue aproposs .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue aproposs .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue apropos.php",

"groupTitle": "Webvue apropos"

},{

"type": "post",

"url": "/webvue_team/add",

"title": "Add Webvue team.",

"version": "0.1.0",

"name": "Addwebvue_team",

"group": "webvue_team",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue team unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team Cant be Accessed permission name : api_webvue_team_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue teams Input Name Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue teams .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Role",

  "description": "<p>Mandatory role of Webvue teams Input Role Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Webvue teams .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_team.php",

"groupTitle": "Webvue team"

},

{

"type": "get",

"url": "/webvue_team/all",

"title": "Get all Webvue teams.",

"version": "0.1.0",

"name": "Allwebvue_team",

"group": "webvue_team",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue teams unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue teams unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue team_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue teams.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue teams.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue teams.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, name, img_url, role, description</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue team.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue team",

"description": "<p>Webvue team data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team.php",

"groupTitle": "Webvue team"

},

{

"type": "post",

"url": "/webvue_team/delete",

"title": "Delete Webvue team.",

"version": "0.1.0",

"name": "Deletewebvue_team",

"group": "webvue_team",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue teams unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue teams unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team Cant be Accessed permission name : api_Webvue team_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue teams .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team.php",

"groupTitle": "Webvue team"

},

{

"type": "get",

"url": "/webvue_team/detail",

"title": "Detail Webvue team.",

"version": "0.1.0",

"name": "Detailwebvue_team",

"group": "webvue_team",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue teams unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue teams unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team Cant be Accessed permission name : api_Webvue team_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue teams.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue team.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue teamNotFound",

"description": "<p>Webvue team data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team.php",

"groupTitle": "Webvue team"

},

{

"type": "post",

"url": "/webvue_team/update",

"title": "Update Webvue team.",

"version": "0.1.0",

"name": "Updatewebvue_team",

"group": "webvue_team",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue teams unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue teams unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue team Cant be Accessed permission name : api_Webvue team_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue teams Input Name Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue teams .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Role",

  "description": "<p>Mandatory role of Webvue teams Input Role Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Webvue teams .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue team.php",

"groupTitle": "Webvue team"

},{


"type": "post",


"url": "/parcels/add",


"title": "Add Parcels.",


"version": "0.1.0",


"name": "Addparcels",


"group": "parcels",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Parcels unique access-key.</p>"


}


,


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Parcels unique token.</p>"


}




]


}


},


"permission": [


{


"name": "Parcels Cant be Accessed permission name : api_parcels_add"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Name",


  "description": "<p>Mandatory name of Parcelss Input Name Max Length : 200..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Region",


  "description": "<p>Mandatory region of Parcelss Input Region Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Gouvernorat",


  "description": "<p>Mandatory gouvernorat of Parcelss Input Gouvernorat Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nbr_pieds",


  "description": "<p>Mandatory nbr_pieds of Parcelss Input Nbr Pieds Max Length : 11..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_culture",


  "description": "<p>Mandatory mode_culture of Parcelss Input Mode Culture Max Length : 200..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nbr_hect",


  "description": "<p>Mandatory nbr_hect of Parcelss Input Nbr Hect Max Length : 11..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_de_planteur",


  "description": "<p>Mandatory mode_de_planteur of Parcelss Input Mode De Planteur Max Length : 3000..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Parcelss Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Parcels.php",


"groupTitle": "Parcels"


},


{


"type": "get",


"url": "/parcels/all",


"title": "Get all Parcelss.",


"version": "0.1.0",


"name": "Allparcels",


"group": "parcels",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Parcelss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Parcelss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "{} Cant be Accessed permission name : api_Parcels_all"


}


],


"parameter": {


"fields": {


"Parameter": [








{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Field",


"defaultValue": "All Field",


"description": "<p>Optional field of Parcelss.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Start",


"defaultValue": "0",


"description": "<p>Optional start index of Parcelss.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Limit",


"defaultValue": "10",


"description": "<p>Optional limit data of Parcelss.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_field",


"defaultValue": "id",


"description": "<p>Sort data by this field. id, name, region, gouvernorat, nbr_pieds, mode_culture, nbr_hect, mode_de_planteur, user_id</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_order",


"defaultValue": "DESC",


"description": "<p>Sort data order this field ASC or DESC.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Filters",


"defaultValue": "",


"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Parcels.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "NoDataParcels",


"description": "<p>Parcels data is nothing.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Parcels.php",


"groupTitle": "Parcels"


},


{


"type": "post",


"url": "/parcels/delete",


"title": "Delete Parcels.",


"version": "0.1.0",


"name": "Deleteparcels",


"group": "parcels",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Parcelss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Parcelss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Parcels Cant be Accessed permission name : api_Parcels_delete"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Parcelss .</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Parcels.php",


"groupTitle": "Parcels"


},


{


"type": "get",


"url": "/parcels/detail",


"title": "Detail Parcels.",


"version": "0.1.0",


"name": "Detailparcels",


"group": "parcels",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Parcelss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Parcelss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Parcels Cant be Accessed permission name : api_Parcels_detail"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Parcelss.</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Parcels.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ParcelsNotFound",


"description": "<p>Parcels data is not found.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Parcels.php",


"groupTitle": "Parcels"


},


{


"type": "post",


"url": "/parcels/update",


"title": "Update Parcels.",


"version": "0.1.0",


"name": "Updateparcels",


"group": "parcels",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Parcelss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Parcelss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Parcels Cant be Accessed permission name : api_Parcels_update"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Name",


  "description": "<p>Mandatory name of Parcelss Input Name Max Length : 200..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Region",


  "description": "<p>Mandatory region of Parcelss Input Region Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Gouvernorat",


  "description": "<p>Mandatory gouvernorat of Parcelss Input Gouvernorat Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nbr_pieds",


  "description": "<p>Mandatory nbr_pieds of Parcelss Input Nbr Pieds Max Length : 11..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_culture",


  "description": "<p>Mandatory mode_culture of Parcelss Input Mode Culture Max Length : 200..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nbr_hect",


  "description": "<p>Mandatory nbr_hect of Parcelss Input Nbr Hect Max Length : 11..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Mode_de_planteur",


  "description": "<p>Mandatory mode_de_planteur of Parcelss Input Mode De Planteur Max Length : 3000..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Parcelss Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Parcels.php",


"groupTitle": "Parcels"


},{

    "type": "post",

    "url": "/blog/add",

    "title": "Add Blog.",

    "version": "0.1.0",

    "name": "Addblog",

    "group": "blog",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Api-Key",

            "description": "<p>Blog unique access-key.</p>"

          }

          ,

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Blog unique token.</p>"

          }

                  ]

      }

    },

    "permission": [

      {

        "name": "Blog Cant be Accessed permission name : api_blog_add"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

                    {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Slug",

            "description": "<p>Mandatory slug of Blogs Input Slug Max Length : 200..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Content",

            "description": "<p>Mandatory content of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Title",

            "description": "<p>Mandatory title of Blogs Input Title Max Length : 255..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Image",

            "description": "<p>Mandatory image of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Category",

            "description": "<p>Mandatory category of Blogs Input Category Max Length : 200..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Tags",

            "description": "<p>Mandatory tags of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Status",

            "description": "<p>Mandatory status of Blogs Input Status Max Length : 10..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Author",

            "description": "<p>Mandatory author of Blogs Input Author Max Length : 100..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Viewers",

            "description": "<p>Mandatory viewers of Blogs Input Viewers Max Length : 11..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Created_at",

            "description": "<p>Mandatory created_at of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Updated_at",

            "description": "<p>Mandatory updated_at of Blogs .</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "ValidationError",

            "description": "<p>Error validation.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Blog.php",

    "groupTitle": "Blog"

  },

  {

    "type": "get",

    "url": "/blog/all",

    "title": "Get all Blogs.",

    "version": "0.1.0",

    "name": "Allblog",

    "group": "blog",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Api-Key",

            "description": "<p>Blogs unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Blogs unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "{} Cant be Accessed permission name : api_Blog_all"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

         

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Field",

            "defaultValue": "All Field",

            "description": "<p>Optional field of Blogs.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Start",

            "defaultValue": "0",

            "description": "<p>Optional start index of Blogs.</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": true,

            "field": "Limit",

            "defaultValue": "10",

            "description": "<p>Optional limit data of Blogs.</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "Array",

            "optional": false,

            "field": "Data",

            "description": "<p>data of Blog.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "NoDataBlog",

            "description": "<p>Blog data is nothing.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Blog.php",

    "groupTitle": "Blog"

  },

  {

    "type": "post",

    "url": "/Blog/delete",

    "title": "Delete Blog.",

    "version": "0.1.0",

    "name": "Deleteblog",

    "group": "blog",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Api-Key",

            "description": "<p>Blogs unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Blogs unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Blog Cant be Accessed permission name : api_Blog_delete"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "Integer",

            "optional": false,

            "field": "Id",

            "description": "<p>Mandatory id of Blogs .</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "ValidationError",

            "description": "<p>Error validation.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Blog.php",

    "groupTitle": "Blog"

  },

  {

    "type": "get",

    "url": "/Blog/detail",

    "title": "Detail Blog.",

    "version": "0.1.0",

    "name": "Detailblog",

    "group": "blog",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Api-Key",

            "description": "<p>Blogs unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Blogs unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Blog Cant be Accessed permission name : api_Blog_detail"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

          {

            "group": "Parameter",

            "type": "Integer",

            "optional": false,

            "field": "Id",

            "description": "<p>Mandatory id of Blogs.</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "Array",

            "optional": false,

            "field": "Data",

            "description": "<p>data of Blog.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "BlogNotFound",

            "description": "<p>Blog data is not found.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Blog.php",

    "groupTitle": "Blog"

  },

  {

    "type": "post",

    "url": "/Blog/update",

    "title": "Update Blog.",

    "version": "0.1.0",

    "name": "Updateblog",

    "group": "blog",

    "header": {

      "fields": {

        "Header": [

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Api-Key",

            "description": "<p>Blogs unique access-key.</p>"

          },

          {

            "group": "Header",

            "type": "String",

            "optional": false,

            "field": "X-Token",

            "description": "<p>Blogs unique token.</p>"

          }

        ]

      }

    },

    "permission": [

      {

        "name": "Blog Cant be Accessed permission name : api_Blog_update"

      }

    ],

    "parameter": {

      "fields": {

        "Parameter": [

                    {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Slug",

            "description": "<p>Mandatory slug of Blogs Input Slug Max Length : 200..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Content",

            "description": "<p>Mandatory content of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Title",

            "description": "<p>Mandatory title of Blogs Input Title Max Length : 255..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Image",

            "description": "<p>Mandatory image of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Category",

            "description": "<p>Mandatory category of Blogs Input Category Max Length : 200..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Tags",

            "description": "<p>Mandatory tags of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Status",

            "description": "<p>Mandatory status of Blogs Input Status Max Length : 10..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Author",

            "description": "<p>Mandatory author of Blogs Input Author Max Length : 100..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Viewers",

            "description": "<p>Mandatory viewers of Blogs Input Viewers Max Length : 11..</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Created_at",

            "description": "<p>Mandatory created_at of Blogs .</p>"

          },

          {

            "group": "Parameter",

            "type": "String",

            "optional": false,

            "field": "Updated_at",

            "description": "<p>Mandatory updated_at of Blogs .</p>"

          }

        ]

      }

    },

    "success": {

      "fields": {

        "Success 200": [

          {

            "group": "Success 200",

            "type": "Boolean",

            "optional": false,

            "field": "Status",

            "description": "<p>status response api.</p>"

          },

          {

            "group": "Success 200",

            "type": "String",

            "optional": false,

            "field": "Message",

            "description": "<p>message response api.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Success-Response:",

          "content": "HTTP/1.1 200 OK",

          "type": "json"

        }

      ]

    },

    "error": {

      "fields": {

        "Error 4xx": [

          {

            "group": "Error 4xx",

            "optional": false,

            "field": "ValidationError",

            "description": "<p>Error validation.</p>"

          }

        ]

      },

      "examples": [

        {

          "title": "Error-Response:",

          "content": "HTTP/1.1 403 Not Acceptable",

          "type": "json"

        }

      ]

    },

    "filename": "application/controllers/api/Blog.php",

    "groupTitle": "Blog"

  },{

"type": "post",

"url": "/tfarhida_stades/add",

"title": "Add Tfarhida stades.",

"version": "0.1.0",

"name": "Addtfarhida_stades",

"group": "tfarhida_stades",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Tfarhida stades unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Tfarhida stades Cant be Accessed permission name : api_tfarhida_stades_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Tfarhida stadess Input Name Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Taille",

  "description": "<p>Mandatory taille of Tfarhida stadess Input Taille Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Localisation",

  "description": "<p>Mandatory localisation of Tfarhida stadess Input Localisation Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Tel",

  "description": "<p>Mandatory tel of Tfarhida stadess Input Tel Max Length : 300..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Tfarhida_stades.php",

"groupTitle": "Tfarhida stades"

},

{

"type": "get",

"url": "/tfarhida_stades/all",

"title": "Get all Tfarhida stadess.",

"version": "0.1.0",

"name": "Alltfarhida_stades",

"group": "tfarhida_stades",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Tfarhida stadess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Tfarhida stadess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Tfarhida stades_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Tfarhida stadess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Tfarhida stadess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Tfarhida stadess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, name, taille, localisation, tel</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Tfarhida stades.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataTfarhida stades",

"description": "<p>Tfarhida stades data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Tfarhida stades.php",

"groupTitle": "Tfarhida stades"

},

{

"type": "post",

"url": "/tfarhida_stades/delete",

"title": "Delete Tfarhida stades.",

"version": "0.1.0",

"name": "Deletetfarhida_stades",

"group": "tfarhida_stades",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Tfarhida stadess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Tfarhida stadess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Tfarhida stades Cant be Accessed permission name : api_Tfarhida stades_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Tfarhida stadess .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Tfarhida stades.php",

"groupTitle": "Tfarhida stades"

},

{

"type": "get",

"url": "/tfarhida_stades/detail",

"title": "Detail Tfarhida stades.",

"version": "0.1.0",

"name": "Detailtfarhida_stades",

"group": "tfarhida_stades",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Tfarhida stadess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Tfarhida stadess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Tfarhida stades Cant be Accessed permission name : api_Tfarhida stades_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Tfarhida stadess.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Tfarhida stades.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Tfarhida stadesNotFound",

"description": "<p>Tfarhida stades data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Tfarhida stades.php",

"groupTitle": "Tfarhida stades"

},

{

"type": "post",

"url": "/tfarhida_stades/update",

"title": "Update Tfarhida stades.",

"version": "0.1.0",

"name": "Updatetfarhida_stades",

"group": "tfarhida_stades",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Tfarhida stadess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Tfarhida stadess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Tfarhida stades Cant be Accessed permission name : api_Tfarhida stades_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Tfarhida stadess Input Name Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Taille",

  "description": "<p>Mandatory taille of Tfarhida stadess Input Taille Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Localisation",

  "description": "<p>Mandatory localisation of Tfarhida stadess Input Localisation Max Length : 300..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Tel",

  "description": "<p>Mandatory tel of Tfarhida stadess Input Tel Max Length : 300..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Tfarhida stades.php",

"groupTitle": "Tfarhida stades"

},{
"type": "post",
"url": "/agritun_transport/add",
"title": "Add Agritun transport.",
"version": "0.1.0",
"name": "Addagritun_transport",
"group": "agritun_transport",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun transport unique access-key.</p>"
}
,
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun transport unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun transport Cant be Accessed permission name : api_agritun_transport_add"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Id_transporteur",
  "description": "<p>Mandatory id_transporteur of Agritun transports Input Id Transporteur Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte",
  "description": "<p>Mandatory qte of Agritun transports Input Qte Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte_unite",
  "description": "<p>Mandatory qte_unite of Agritun transports Input Qte Unite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Cout",
  "description": "<p>Mandatory cout of Agritun transports Input Cout Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun transports Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun transports Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun_transport.php",
"groupTitle": "Agritun transport"
},
{
"type": "get",
"url": "/agritun_transport/all",
"title": "Get all Agritun transports.",
"version": "0.1.0",
"name": "Allagritun_transport",
"group": "agritun_transport",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun transports unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun transports unique token.</p>"
}
]
}
},
"permission": [
{
"name": "{} Cant be Accessed permission name : api_Agritun transport_all"
}
],
"parameter": {
"fields": {
"Parameter": [


{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Field",
"defaultValue": "All Field",
"description": "<p>Optional field of Agritun transports.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Start",
"defaultValue": "0",
"description": "<p>Optional start index of Agritun transports.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Limit",
"defaultValue": "10",
"description": "<p>Optional limit data of Agritun transports.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_field",
"defaultValue": "id",
"description": "<p>Sort data by this field. id, id_transporteur, qte, qte_unite, cout, date, user_id, id_parcel</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_order",
"defaultValue": "DESC",
"description": "<p>Sort data order this field ASC or DESC.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Filters",
"defaultValue": "",
"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun transport.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "NoDataAgritun transport",
"description": "<p>Agritun transport data is nothing.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun transport.php",
"groupTitle": "Agritun transport"
},
{
"type": "post",
"url": "/agritun_transport/delete",
"title": "Delete Agritun transport.",
"version": "0.1.0",
"name": "Deleteagritun_transport",
"group": "agritun_transport",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun transports unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun transports unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun transport Cant be Accessed permission name : api_Agritun transport_delete"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun transports .</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun transport.php",
"groupTitle": "Agritun transport"
},
{
"type": "get",
"url": "/agritun_transport/detail",
"title": "Detail Agritun transport.",
"version": "0.1.0",
"name": "Detailagritun_transport",
"group": "agritun_transport",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun transports unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun transports unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun transport Cant be Accessed permission name : api_Agritun transport_detail"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun transports.</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun transport.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "Agritun transportNotFound",
"description": "<p>Agritun transport data is not found.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun transport.php",
"groupTitle": "Agritun transport"
},
{
"type": "post",
"url": "/agritun_transport/update",
"title": "Update Agritun transport.",
"version": "0.1.0",
"name": "Updateagritun_transport",
"group": "agritun_transport",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun transports unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun transports unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun transport Cant be Accessed permission name : api_Agritun transport_update"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Id_transporteur",
  "description": "<p>Mandatory id_transporteur of Agritun transports Input Id Transporteur Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte",
  "description": "<p>Mandatory qte of Agritun transports Input Qte Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte_unite",
  "description": "<p>Mandatory qte_unite of Agritun transports Input Qte Unite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Cout",
  "description": "<p>Mandatory cout of Agritun transports Input Cout Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun transports Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun transports Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun transport.php",
"groupTitle": "Agritun transport"
},{

"type": "post",

"url": "/webvue_settings/add",

"title": "Add Webvue settings.",

"version": "0.1.0",

"name": "Addwebvue_settings",

"group": "webvue_settings",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue settings unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue settings Cant be Accessed permission name : api_webvue_settings_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Adresse",

  "description": "<p>Mandatory adresse of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Numeros",

  "description": "<p>Mandatory numeros of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Emails",

  "description": "<p>Mandatory emails of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Horaires",

  "description": "<p>Mandatory horaires of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Logo_url",

  "description": "<p>Mandatory logo_url of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Footer_description",

  "description": "<p>Mandatory footer_description of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Favicon",

  "description": "<p>Mandatory favicon of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Copyright",

  "description": "<p>Mandatory copyright of Webvue settingss Input Copyright Max Length : 10..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Fb",

  "description": "<p>Mandatory fb of Webvue settingss Input Fb Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Twitter",

  "description": "<p>Mandatory twitter of Webvue settingss Input Twitter Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Instagram",

  "description": "<p>Mandatory instagram of Webvue settingss Input Instagram Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Linkedin",

  "description": "<p>Mandatory linkedin of Webvue settingss Input Linkedin Max Length : 200..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_settings.php",

"groupTitle": "Webvue settings"

},

{

"type": "get",

"url": "/webvue_settings/all",

"title": "Get all Webvue settingss.",

"version": "0.1.0",

"name": "Allwebvue_settings",

"group": "webvue_settings",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue settingss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue settingss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue settings_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue settingss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue settingss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue settingss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, adresse, numeros, emails, horaires, logo_url, footer_description, favicon, copyright, fb, twitter, instagram, linkedin</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue settings.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue settings",

"description": "<p>Webvue settings data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue settings.php",

"groupTitle": "Webvue settings"

},

{

"type": "post",

"url": "/webvue_settings/delete",

"title": "Delete Webvue settings.",

"version": "0.1.0",

"name": "Deletewebvue_settings",

"group": "webvue_settings",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue settingss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue settingss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue settings Cant be Accessed permission name : api_Webvue settings_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue settingss .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue settings.php",

"groupTitle": "Webvue settings"

},

{

"type": "get",

"url": "/webvue_settings/detail",

"title": "Detail Webvue settings.",

"version": "0.1.0",

"name": "Detailwebvue_settings",

"group": "webvue_settings",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue settingss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue settingss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue settings Cant be Accessed permission name : api_Webvue settings_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue settingss.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue settings.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue settingsNotFound",

"description": "<p>Webvue settings data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue settings.php",

"groupTitle": "Webvue settings"

},

{

"type": "post",

"url": "/webvue_settings/update",

"title": "Update Webvue settings.",

"version": "0.1.0",

"name": "Updatewebvue_settings",

"group": "webvue_settings",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue settingss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue settingss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue settings Cant be Accessed permission name : api_Webvue settings_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Adresse",

  "description": "<p>Mandatory adresse of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Numeros",

  "description": "<p>Mandatory numeros of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Emails",

  "description": "<p>Mandatory emails of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Horaires",

  "description": "<p>Mandatory horaires of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Logo_url",

  "description": "<p>Mandatory logo_url of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Footer_description",

  "description": "<p>Mandatory footer_description of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Favicon",

  "description": "<p>Mandatory favicon of Webvue settingss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Copyright",

  "description": "<p>Mandatory copyright of Webvue settingss Input Copyright Max Length : 10..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Fb",

  "description": "<p>Mandatory fb of Webvue settingss Input Fb Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Twitter",

  "description": "<p>Mandatory twitter of Webvue settingss Input Twitter Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Instagram",

  "description": "<p>Mandatory instagram of Webvue settingss Input Instagram Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Linkedin",

  "description": "<p>Mandatory linkedin of Webvue settingss Input Linkedin Max Length : 200..</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue settings.php",

"groupTitle": "Webvue settings"

},{
"type": "post",
"url": "/agritun_achat/add",
"title": "Add Agritun achat.",
"version": "0.1.0",
"name": "Addagritun_achat",
"group": "agritun_achat",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun achat unique access-key.</p>"
}
,
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun achat unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun achat Cant be Accessed permission name : api_agritun_achat_add"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Fournisseur",
  "description": "<p>Mandatory fournisseur of Agritun achats Input Fournisseur Max Length : 400..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Article",
  "description": "<p>Mandatory article of Agritun achats Input Article Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte",
  "description": "<p>Mandatory qte of Agritun achats Input Qte Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Prix_u",
  "description": "<p>Mandatory prix_u of Agritun achats Input Prix U Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Total",
  "description": "<p>Mandatory total of Agritun achats Input Total Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun achats Input User Id Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun achats Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun achats Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun_achat.php",
"groupTitle": "Agritun achat"
},
{
"type": "get",
"url": "/agritun_achat/all",
"title": "Get all Agritun achats.",
"version": "0.1.0",
"name": "Allagritun_achat",
"group": "agritun_achat",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun achats unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun achats unique token.</p>"
}
]
}
},
"permission": [
{
"name": "{} Cant be Accessed permission name : api_Agritun achat_all"
}
],
"parameter": {
"fields": {
"Parameter": [


{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Field",
"defaultValue": "All Field",
"description": "<p>Optional field of Agritun achats.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Start",
"defaultValue": "0",
"description": "<p>Optional start index of Agritun achats.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Limit",
"defaultValue": "10",
"description": "<p>Optional limit data of Agritun achats.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_field",
"defaultValue": "id",
"description": "<p>Sort data by this field. id, fournisseur, article, qte, prix_u, total, date, user_id, i_src, id_parcel</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_order",
"defaultValue": "DESC",
"description": "<p>Sort data order this field ASC or DESC.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Filters",
"defaultValue": "",
"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun achat.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "NoDataAgritun achat",
"description": "<p>Agritun achat data is nothing.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun achat.php",
"groupTitle": "Agritun achat"
},
{
"type": "post",
"url": "/agritun_achat/delete",
"title": "Delete Agritun achat.",
"version": "0.1.0",
"name": "Deleteagritun_achat",
"group": "agritun_achat",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun achats unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun achats unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun achat Cant be Accessed permission name : api_Agritun achat_delete"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun achats .</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun achat.php",
"groupTitle": "Agritun achat"
},
{
"type": "get",
"url": "/agritun_achat/detail",
"title": "Detail Agritun achat.",
"version": "0.1.0",
"name": "Detailagritun_achat",
"group": "agritun_achat",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun achats unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun achats unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun achat Cant be Accessed permission name : api_Agritun achat_detail"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun achats.</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun achat.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "Agritun achatNotFound",
"description": "<p>Agritun achat data is not found.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun achat.php",
"groupTitle": "Agritun achat"
},
{
"type": "post",
"url": "/agritun_achat/update",
"title": "Update Agritun achat.",
"version": "0.1.0",
"name": "Updateagritun_achat",
"group": "agritun_achat",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun achats unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun achats unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun achat Cant be Accessed permission name : api_Agritun achat_update"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Fournisseur",
  "description": "<p>Mandatory fournisseur of Agritun achats Input Fournisseur Max Length : 400..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Article",
  "description": "<p>Mandatory article of Agritun achats Input Article Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte",
  "description": "<p>Mandatory qte of Agritun achats Input Qte Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Prix_u",
  "description": "<p>Mandatory prix_u of Agritun achats Input Prix U Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Total",
  "description": "<p>Mandatory total of Agritun achats Input Total Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun achats Input User Id Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun achats Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun achats Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun achat.php",
"groupTitle": "Agritun achat"
},{
"type": "post",
"url": "/agritun_paiement/add",
"title": "Add Agritun paiement.",
"version": "0.1.0",
"name": "Addagritun_paiement",
"group": "agritun_paiement",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun paiement unique access-key.</p>"
}
,
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun paiement unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun paiement Cant be Accessed permission name : api_agritun_paiement_add"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Service",
  "description": "<p>Mandatory service of Agritun paiements Input Service Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Beneficiaire",
  "description": "<p>Mandatory beneficiaire of Agritun paiements Input Beneficiaire Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Montant",
  "description": "<p>Mandatory montant of Agritun paiements Input Montant Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun paiements Input User Id Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "I_src",
  "description": "<p>Optional i_src of Agritun paiements Input I Src Max Length : 500..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun paiements Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun_paiement.php",
"groupTitle": "Agritun paiement"
},
{
"type": "get",
"url": "/agritun_paiement/all",
"title": "Get all Agritun paiements.",
"version": "0.1.0",
"name": "Allagritun_paiement",
"group": "agritun_paiement",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun paiements unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun paiements unique token.</p>"
}
]
}
},
"permission": [
{
"name": "{} Cant be Accessed permission name : api_Agritun paiement_all"
}
],
"parameter": {
"fields": {
"Parameter": [


{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Field",
"defaultValue": "All Field",
"description": "<p>Optional field of Agritun paiements.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Start",
"defaultValue": "0",
"description": "<p>Optional start index of Agritun paiements.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Limit",
"defaultValue": "10",
"description": "<p>Optional limit data of Agritun paiements.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_field",
"defaultValue": "id",
"description": "<p>Sort data by this field. id, service, beneficiaire, montant, date, user_id, i_src, id_parcel</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_order",
"defaultValue": "DESC",
"description": "<p>Sort data order this field ASC or DESC.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Filters",
"defaultValue": "",
"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun paiement.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "NoDataAgritun paiement",
"description": "<p>Agritun paiement data is nothing.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun paiement.php",
"groupTitle": "Agritun paiement"
},
{
"type": "post",
"url": "/agritun_paiement/delete",
"title": "Delete Agritun paiement.",
"version": "0.1.0",
"name": "Deleteagritun_paiement",
"group": "agritun_paiement",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun paiements unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun paiements unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun paiement Cant be Accessed permission name : api_Agritun paiement_delete"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun paiements .</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun paiement.php",
"groupTitle": "Agritun paiement"
},
{
"type": "get",
"url": "/agritun_paiement/detail",
"title": "Detail Agritun paiement.",
"version": "0.1.0",
"name": "Detailagritun_paiement",
"group": "agritun_paiement",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun paiements unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun paiements unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun paiement Cant be Accessed permission name : api_Agritun paiement_detail"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun paiements.</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun paiement.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "Agritun paiementNotFound",
"description": "<p>Agritun paiement data is not found.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun paiement.php",
"groupTitle": "Agritun paiement"
},
{
"type": "post",
"url": "/agritun_paiement/update",
"title": "Update Agritun paiement.",
"version": "0.1.0",
"name": "Updateagritun_paiement",
"group": "agritun_paiement",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun paiements unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun paiements unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun paiement Cant be Accessed permission name : api_Agritun paiement_update"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Service",
  "description": "<p>Mandatory service of Agritun paiements Input Service Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Beneficiaire",
  "description": "<p>Mandatory beneficiaire of Agritun paiements Input Beneficiaire Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Montant",
  "description": "<p>Mandatory montant of Agritun paiements Input Montant Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun paiements Input User Id Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "I_src",
  "description": "<p>Optional i_src of Agritun paiements Input I Src Max Length : 500..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": true,
  "field": "Id_parcel",
  "description": "<p>Optional id_parcel of Agritun paiements Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun paiement.php",
"groupTitle": "Agritun paiement"
},{

"type": "post",

"url": "/webvue_partenaires/add",

"title": "Add Webvue partenaires.",

"version": "0.1.0",

"name": "Addwebvue_partenaires",

"group": "webvue_partenaires",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue partenaires unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue partenaires Cant be Accessed permission name : api_webvue_partenaires_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Image",

  "description": "<p>Mandatory image of Webvue partenairess .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue partenairess Input Name Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue partenairess .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_partenaires.php",

"groupTitle": "Webvue partenaires"

},

{

"type": "get",

"url": "/webvue_partenaires/all",

"title": "Get all Webvue partenairess.",

"version": "0.1.0",

"name": "Allwebvue_partenaires",

"group": "webvue_partenaires",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue partenairess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue partenairess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue partenaires_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue partenairess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue partenairess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue partenairess.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, image, name, link</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue partenaires.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue partenaires",

"description": "<p>Webvue partenaires data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue partenaires.php",

"groupTitle": "Webvue partenaires"

},

{

"type": "post",

"url": "/webvue_partenaires/delete",

"title": "Delete Webvue partenaires.",

"version": "0.1.0",

"name": "Deletewebvue_partenaires",

"group": "webvue_partenaires",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue partenairess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue partenairess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue partenaires Cant be Accessed permission name : api_Webvue partenaires_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue partenairess .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue partenaires.php",

"groupTitle": "Webvue partenaires"

},

{

"type": "get",

"url": "/webvue_partenaires/detail",

"title": "Detail Webvue partenaires.",

"version": "0.1.0",

"name": "Detailwebvue_partenaires",

"group": "webvue_partenaires",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue partenairess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue partenairess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue partenaires Cant be Accessed permission name : api_Webvue partenaires_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue partenairess.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue partenaires.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue partenairesNotFound",

"description": "<p>Webvue partenaires data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue partenaires.php",

"groupTitle": "Webvue partenaires"

},

{

"type": "post",

"url": "/webvue_partenaires/update",

"title": "Update Webvue partenaires.",

"version": "0.1.0",

"name": "Updatewebvue_partenaires",

"group": "webvue_partenaires",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue partenairess unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue partenairess unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue partenaires Cant be Accessed permission name : api_Webvue partenaires_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Image",

  "description": "<p>Mandatory image of Webvue partenairess .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Name",

  "description": "<p>Mandatory name of Webvue partenairess Input Name Max Length : 200..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue partenairess .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue partenaires.php",

"groupTitle": "Webvue partenaires"

},{

"type": "post",

"url": "/webvue_works/add",

"title": "Add Webvue works.",

"version": "0.1.0",

"name": "Addwebvue_works",

"group": "webvue_works",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue works unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works Cant be Accessed permission name : api_webvue_works_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory title of Webvue workss Input Title Max Length : 400..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Cat_id",

  "description": "<p>Mandatory cat_id of Webvue workss Input Cat Id Max Length : 40..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue workss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue workss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Webvue workss .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_works.php",

"groupTitle": "Webvue works"

},

{

"type": "get",

"url": "/webvue_works/all",

"title": "Get all Webvue workss.",

"version": "0.1.0",

"name": "Allwebvue_works",

"group": "webvue_works",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue workss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue workss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue works_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue workss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue workss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue workss.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, title, cat_id, img_url, link, description</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue works.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue works",

"description": "<p>Webvue works data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works.php",

"groupTitle": "Webvue works"

},

{

"type": "post",

"url": "/webvue_works/delete",

"title": "Delete Webvue works.",

"version": "0.1.0",

"name": "Deletewebvue_works",

"group": "webvue_works",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue workss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue workss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works Cant be Accessed permission name : api_Webvue works_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue workss .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works.php",

"groupTitle": "Webvue works"

},

{

"type": "get",

"url": "/webvue_works/detail",

"title": "Detail Webvue works.",

"version": "0.1.0",

"name": "Detailwebvue_works",

"group": "webvue_works",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue workss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue workss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works Cant be Accessed permission name : api_Webvue works_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue workss.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue works.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue worksNotFound",

"description": "<p>Webvue works data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works.php",

"groupTitle": "Webvue works"

},

{

"type": "post",

"url": "/webvue_works/update",

"title": "Update Webvue works.",

"version": "0.1.0",

"name": "Updatewebvue_works",

"group": "webvue_works",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue workss unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue workss unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue works Cant be Accessed permission name : api_Webvue works_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Title",

  "description": "<p>Mandatory title of Webvue workss Input Title Max Length : 400..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Cat_id",

  "description": "<p>Mandatory cat_id of Webvue workss Input Cat Id Max Length : 40..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue workss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue workss .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Description",

  "description": "<p>Mandatory description of Webvue workss .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue works.php",

"groupTitle": "Webvue works"

},{
"type": "post",
"url": "/agritun_masra_sortant/add",
"title": "Add Agritun masra sortant.",
"version": "0.1.0",
"name": "Addagritun_masra_sortant",
"group": "agritun_masra_sortant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra sortant unique access-key.</p>"
}
,
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra sortant unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra sortant Cant be Accessed permission name : api_agritun_masra_sortant_add"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Masra",
  "description": "<p>Mandatory masra of Agritun masra sortants Input Masra Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte_zitoun",
  "description": "<p>Mandatory qte_zitoun of Agritun masra sortants Input Qte Zitoun Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Prix_u",
  "description": "<p>Mandatory prix_u of Agritun masra sortants Input Prix U Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte_zit",
  "description": "<p>Mandatory qte_zit of Agritun masra sortants Input Qte Zit Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite",
  "description": "<p>Mandatory qualite of Agritun masra sortants Input Qualite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Cout",
  "description": "<p>Mandatory cout of Agritun masra sortants Input Cout Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite_zit",
  "description": "<p>Mandatory qualite_zit of Agritun masra sortants Input Qualite Zit Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun masra sortants Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun masra sortants Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Id_parcel",
  "description": "<p>Mandatory id_parcel of Agritun masra sortants Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun_masra_sortant.php",
"groupTitle": "Agritun masra sortant"
},
{
"type": "get",
"url": "/agritun_masra_sortant/all",
"title": "Get all Agritun masra sortants.",
"version": "0.1.0",
"name": "Allagritun_masra_sortant",
"group": "agritun_masra_sortant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra sortants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra sortants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "{} Cant be Accessed permission name : api_Agritun masra sortant_all"
}
],
"parameter": {
"fields": {
"Parameter": [


{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Field",
"defaultValue": "All Field",
"description": "<p>Optional field of Agritun masra sortants.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Start",
"defaultValue": "0",
"description": "<p>Optional start index of Agritun masra sortants.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Limit",
"defaultValue": "10",
"description": "<p>Optional limit data of Agritun masra sortants.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_field",
"defaultValue": "id",
"description": "<p>Sort data by this field. id, masra, qte_zitoun, prix_u, qte_zit, qualite, cout, date, qualite_zit, i_src, user_id, id_parcel</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Sort_order",
"defaultValue": "DESC",
"description": "<p>Sort data order this field ASC or DESC.</p>"
},
{
"group": "Parameter",
"type": "String",
"optional": true,
"field": "Filters",
"defaultValue": "",
"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun masra sortant.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "NoDataAgritun masra sortant",
"description": "<p>Agritun masra sortant data is nothing.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra sortant.php",
"groupTitle": "Agritun masra sortant"
},
{
"type": "post",
"url": "/agritun_masra_sortant/delete",
"title": "Delete Agritun masra sortant.",
"version": "0.1.0",
"name": "Deleteagritun_masra_sortant",
"group": "agritun_masra_sortant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra sortants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra sortants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra sortant Cant be Accessed permission name : api_Agritun masra sortant_delete"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun masra sortants .</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra sortant.php",
"groupTitle": "Agritun masra sortant"
},
{
"type": "get",
"url": "/agritun_masra_sortant/detail",
"title": "Detail Agritun masra sortant.",
"version": "0.1.0",
"name": "Detailagritun_masra_sortant",
"group": "agritun_masra_sortant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra sortants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra sortants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra sortant Cant be Accessed permission name : api_Agritun masra sortant_detail"
}
],
"parameter": {
"fields": {
"Parameter": [
{
"group": "Parameter",
"type": "Integer",
"optional": false,
"field": "Id",
"description": "<p>Mandatory id of Agritun masra sortants.</p>"
}
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
},
{
"group": "Success 200",
"type": "Array",
"optional": false,
"field": "Data",
"description": "<p>data of Agritun masra sortant.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "Agritun masra sortantNotFound",
"description": "<p>Agritun masra sortant data is not found.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra sortant.php",
"groupTitle": "Agritun masra sortant"
},
{
"type": "post",
"url": "/agritun_masra_sortant/update",
"title": "Update Agritun masra sortant.",
"version": "0.1.0",
"name": "Updateagritun_masra_sortant",
"group": "agritun_masra_sortant",
"header": {
"fields": {
"Header": [
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Api-Key",
"description": "<p>Agritun masra sortants unique access-key.</p>"
},
{
"group": "Header",
"type": "String",
"optional": false,
"field": "X-Token",
"description": "<p>Agritun masra sortants unique token.</p>"
}
]
}
},
"permission": [
{
"name": "Agritun masra sortant Cant be Accessed permission name : api_Agritun masra sortant_update"
}
],
"parameter": {
"fields": {
"Parameter": [
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Masra",
  "description": "<p>Mandatory masra of Agritun masra sortants Input Masra Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte_zitoun",
  "description": "<p>Mandatory qte_zitoun of Agritun masra sortants Input Qte Zitoun Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Prix_u",
  "description": "<p>Mandatory prix_u of Agritun masra sortants Input Prix U Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qte_zit",
  "description": "<p>Mandatory qte_zit of Agritun masra sortants Input Qte Zit Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite",
  "description": "<p>Mandatory qualite of Agritun masra sortants Input Qualite Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Cout",
  "description": "<p>Mandatory cout of Agritun masra sortants Input Cout Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Qualite_zit",
  "description": "<p>Mandatory qualite_zit of Agritun masra sortants Input Qualite Zit Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "I_src",
  "description": "<p>Mandatory i_src of Agritun masra sortants Input I Src Max Length : 300..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "User_id",
  "description": "<p>Mandatory user_id of Agritun masra sortants Input User Id Max Length : 11..</p>"
  },
  {
  "group": "Parameter",
  "type": "String",
  "optional": false,
  "field": "Id_parcel",
  "description": "<p>Mandatory id_parcel of Agritun masra sortants Input Id Parcel Max Length : 300..</p>"
  }
]
}
},
"success": {
"fields": {
"Success 200": [
{
"group": "Success 200",
"type": "Boolean",
"optional": false,
"field": "Status",
"description": "<p>status response api.</p>"
},
{
"group": "Success 200",
"type": "String",
"optional": false,
"field": "Message",
"description": "<p>message response api.</p>"
}
]
},
"examples": [
{
"title": "Success-Response:",
"content": "HTTP/1.1 200 OK",
"type": "json"
}
]
},
"error": {
"fields": {
"Error 4xx": [
{
"group": "Error 4xx",
"optional": false,
"field": "ValidationError",
"description": "<p>Error validation.</p>"
}
]
},
"examples": [
{
"title": "Error-Response:",
"content": "HTTP/1.1 403 Not Acceptable",
"type": "json"
}
]
},
"filename": "application/controllers/api/Agritun masra sortant.php",
"groupTitle": "Agritun masra sortant"
},{


"type": "post",


"url": "/agritun_transporteurs/add",


"title": "Add Agritun transporteurs.",


"version": "0.1.0",


"name": "Addagritun_transporteurs",


"group": "agritun_transporteurs",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun transporteurs unique access-key.</p>"


}


,


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun transporteurs unique token.</p>"


}




]


}


},


"permission": [


{


"name": "Agritun transporteurs Cant be Accessed permission name : api_agritun_transporteurs_add"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Type_transporteur",


  "description": "<p>Mandatory type_transporteur of Agritun transporteurss Input Type Transporteur Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nom_chauffeur",


  "description": "<p>Mandatory nom_chauffeur of Agritun transporteurss Input Nom Chauffeur Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Matricule",


  "description": "<p>Optional matricule of Agritun transporteurss Input Matricule Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Tel",


  "description": "<p>Optional tel of Agritun transporteurss Input Tel Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun transporteurss Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun_transporteurs.php",


"groupTitle": "Agritun transporteurs"


},


{


"type": "get",


"url": "/agritun_transporteurs/all",


"title": "Get all Agritun transporteurss.",


"version": "0.1.0",


"name": "Allagritun_transporteurs",


"group": "agritun_transporteurs",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun transporteurss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun transporteurss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "{} Cant be Accessed permission name : api_Agritun transporteurs_all"


}


],


"parameter": {


"fields": {


"Parameter": [








{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Field",


"defaultValue": "All Field",


"description": "<p>Optional field of Agritun transporteurss.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Start",


"defaultValue": "0",


"description": "<p>Optional start index of Agritun transporteurss.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Limit",


"defaultValue": "10",


"description": "<p>Optional limit data of Agritun transporteurss.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_field",


"defaultValue": "id",


"description": "<p>Sort data by this field. id, type_transporteur, nom_chauffeur, matricule, tel, user_id</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_order",


"defaultValue": "DESC",


"description": "<p>Sort data order this field ASC or DESC.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Filters",


"defaultValue": "",


"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun transporteurs.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "NoDataAgritun transporteurs",


"description": "<p>Agritun transporteurs data is nothing.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun transporteurs.php",


"groupTitle": "Agritun transporteurs"


},


{


"type": "post",


"url": "/agritun_transporteurs/delete",


"title": "Delete Agritun transporteurs.",


"version": "0.1.0",


"name": "Deleteagritun_transporteurs",


"group": "agritun_transporteurs",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun transporteurss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun transporteurss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun transporteurs Cant be Accessed permission name : api_Agritun transporteurs_delete"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun transporteurss .</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun transporteurs.php",


"groupTitle": "Agritun transporteurs"


},


{


"type": "get",


"url": "/agritun_transporteurs/detail",


"title": "Detail Agritun transporteurs.",


"version": "0.1.0",


"name": "Detailagritun_transporteurs",


"group": "agritun_transporteurs",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun transporteurss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun transporteurss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun transporteurs Cant be Accessed permission name : api_Agritun transporteurs_detail"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun transporteurss.</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun transporteurs.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "Agritun transporteursNotFound",


"description": "<p>Agritun transporteurs data is not found.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun transporteurs.php",


"groupTitle": "Agritun transporteurs"


},


{


"type": "post",


"url": "/agritun_transporteurs/update",


"title": "Update Agritun transporteurs.",


"version": "0.1.0",


"name": "Updateagritun_transporteurs",


"group": "agritun_transporteurs",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun transporteurss unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun transporteurss unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun transporteurs Cant be Accessed permission name : api_Agritun transporteurs_update"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Type_transporteur",


  "description": "<p>Mandatory type_transporteur of Agritun transporteurss Input Type Transporteur Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Nom_chauffeur",


  "description": "<p>Mandatory nom_chauffeur of Agritun transporteurss Input Nom Chauffeur Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Matricule",


  "description": "<p>Optional matricule of Agritun transporteurss Input Matricule Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": true,


  "field": "Tel",


  "description": "<p>Optional tel of Agritun transporteurss Input Tel Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun transporteurss Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun transporteurs.php",


"groupTitle": "Agritun transporteurs"


},{


"type": "post",


"url": "/agritun_masra/add",


"title": "Add Agritun masra.",


"version": "0.1.0",


"name": "Addagritun_masra",


"group": "agritun_masra",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun masra unique access-key.</p>"


}


,


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun masra unique token.</p>"


}




]


}


},


"permission": [


{


"name": "Agritun masra Cant be Accessed permission name : api_agritun_masra_add"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Name",


  "description": "<p>Mandatory name of Agritun masras Input Name Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Region",


  "description": "<p>Mandatory region of Agritun masras Input Region Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Tel",


  "description": "<p>Mandatory tel of Agritun masras Input Tel Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun masras Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun_masra.php",


"groupTitle": "Agritun masra"


},


{


"type": "get",


"url": "/agritun_masra/all",


"title": "Get all Agritun masras.",


"version": "0.1.0",


"name": "Allagritun_masra",


"group": "agritun_masra",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun masras unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun masras unique token.</p>"


}


]


}


},


"permission": [


{


"name": "{} Cant be Accessed permission name : api_Agritun masra_all"


}


],


"parameter": {


"fields": {


"Parameter": [








{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Field",


"defaultValue": "All Field",


"description": "<p>Optional field of Agritun masras.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Start",


"defaultValue": "0",


"description": "<p>Optional start index of Agritun masras.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Limit",


"defaultValue": "10",


"description": "<p>Optional limit data of Agritun masras.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_field",


"defaultValue": "id",


"description": "<p>Sort data by this field. id, name, region, tel, date, user_id</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Sort_order",


"defaultValue": "DESC",


"description": "<p>Sort data order this field ASC or DESC.</p>"


},


{


"group": "Parameter",


"type": "String",


"optional": true,


"field": "Filters",


"defaultValue": "",


"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun masra.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "NoDataAgritun masra",


"description": "<p>Agritun masra data is nothing.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun masra.php",


"groupTitle": "Agritun masra"


},


{


"type": "post",


"url": "/agritun_masra/delete",


"title": "Delete Agritun masra.",


"version": "0.1.0",


"name": "Deleteagritun_masra",


"group": "agritun_masra",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun masras unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun masras unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun masra Cant be Accessed permission name : api_Agritun masra_delete"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun masras .</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun masra.php",


"groupTitle": "Agritun masra"


},


{


"type": "get",


"url": "/agritun_masra/detail",


"title": "Detail Agritun masra.",


"version": "0.1.0",


"name": "Detailagritun_masra",


"group": "agritun_masra",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun masras unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun masras unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun masra Cant be Accessed permission name : api_Agritun masra_detail"


}


],


"parameter": {


"fields": {


"Parameter": [


{


"group": "Parameter",


"type": "Integer",


"optional": false,


"field": "Id",


"description": "<p>Mandatory id of Agritun masras.</p>"


}


]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


},


{


"group": "Success 200",


"type": "Array",


"optional": false,


"field": "Data",


"description": "<p>data of Agritun masra.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "Agritun masraNotFound",


"description": "<p>Agritun masra data is not found.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun masra.php",


"groupTitle": "Agritun masra"


},


{


"type": "post",


"url": "/agritun_masra/update",


"title": "Update Agritun masra.",


"version": "0.1.0",


"name": "Updateagritun_masra",


"group": "agritun_masra",


"header": {


"fields": {


"Header": [


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Api-Key",


"description": "<p>Agritun masras unique access-key.</p>"


},


{


"group": "Header",


"type": "String",


"optional": false,


"field": "X-Token",


"description": "<p>Agritun masras unique token.</p>"


}


]


}


},


"permission": [


{


"name": "Agritun masra Cant be Accessed permission name : api_Agritun masra_update"


}


],


"parameter": {


"fields": {


"Parameter": [




  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Name",


  "description": "<p>Mandatory name of Agritun masras Input Name Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Region",


  "description": "<p>Mandatory region of Agritun masras Input Region Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "Tel",


  "description": "<p>Mandatory tel of Agritun masras Input Tel Max Length : 300..</p>"


  },






  {


  "group": "Parameter",


  "type": "String",


  "optional": false,


  "field": "User_id",


  "description": "<p>Mandatory user_id of Agritun masras Input User Id Max Length : 11..</p>"


  }






]


}


},


"success": {


"fields": {


"Success 200": [


{


"group": "Success 200",


"type": "Boolean",


"optional": false,


"field": "Status",


"description": "<p>status response api.</p>"


},


{


"group": "Success 200",


"type": "String",


"optional": false,


"field": "Message",


"description": "<p>message response api.</p>"


}


]


},


"examples": [


{


"title": "Success-Response:",


"content": "HTTP/1.1 200 OK",


"type": "json"


}


]


},


"error": {


"fields": {


"Error 4xx": [


{


"group": "Error 4xx",


"optional": false,


"field": "ValidationError",


"description": "<p>Error validation.</p>"


}


]


},


"examples": [


{


"title": "Error-Response:",


"content": "HTTP/1.1 403 Not Acceptable",


"type": "json"


}


]


},


"filename": "application/controllers/api/Agritun masra.php",


"groupTitle": "Agritun masra"


},{

"type": "post",

"url": "/webvue_accueil/add",

"title": "Add Webvue accueil.",

"version": "0.1.0",

"name": "Addwebvue_accueil",

"group": "webvue_accueil",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue accueil unique access-key.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue accueil Cant be Accessed permission name : api_webvue_accueil_add"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": true,

  "field": "Id",

  "description": "<p>Optional id of Webvue accueils .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Label",

  "description": "<p>Mandatory label of Webvue accueils .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Button",

  "description": "<p>Mandatory button of Webvue accueils Input Button Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue accueils .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue accueils .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue_accueil.php",

"groupTitle": "Webvue accueil"

},

{

"type": "get",

"url": "/webvue_accueil/all",

"title": "Get all Webvue accueils.",

"version": "0.1.0",

"name": "Allwebvue_accueil",

"group": "webvue_accueil",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue accueils unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue accueils unique token.</p>"

}

]

}

},

"permission": [

{

"name": "{} Cant be Accessed permission name : api_Webvue accueil_all"

}

],

"parameter": {

"fields": {

"Parameter": [





{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Field",

"defaultValue": "All Field",

"description": "<p>Optional field of Webvue accueils.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Start",

"defaultValue": "0",

"description": "<p>Optional start index of Webvue accueils.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Limit",

"defaultValue": "10",

"description": "<p>Optional limit data of Webvue accueils.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_field",

"defaultValue": "id",

"description": "<p>Sort data by this field. id, label, button, img_url, link</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Sort_order",

"defaultValue": "DESC",

"description": "<p>Sort data order this field ASC or DESC.</p>"

},

{

"group": "Parameter",

"type": "String",

"optional": true,

"field": "Filters",

"defaultValue": "",

"description": "<p>filters[0][lg] = <code>AND</code>, <code>OR</code><br>filters[0][co][0][fl] = <code>id</code><br>filters[0][co][0][op] = <code>equal</code>, <code>not_equal</code>, <code>greather</code>, <code>greather_equal</code>, <code>smaller_equal</code>, <code>smaller</code>, <code>is_null</code>, <code>not_null</code>, <code>where_in</code>, <code>where_not_in</code>, <code>like</code><br>filters[0][co][0][vl] = 1<br>filters[0][co][0][lg] = <code>OR</code>, <code>AND</code><br><br><br><span class=\"label \">Note</span> : if use like operator you need append <code>%your term%</code> on vl<br>for <code>BETWEEN</code> or <code>IN</code> you can use val1, val2, ..etc</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue accueil.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "NoDataWebvue accueil",

"description": "<p>Webvue accueil data is nothing.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue accueil.php",

"groupTitle": "Webvue accueil"

},

{

"type": "post",

"url": "/webvue_accueil/delete",

"title": "Delete Webvue accueil.",

"version": "0.1.0",

"name": "Deletewebvue_accueil",

"group": "webvue_accueil",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue accueils unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue accueils unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue accueil Cant be Accessed permission name : api_Webvue accueil_delete"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue accueils .</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue accueil.php",

"groupTitle": "Webvue accueil"

},

{

"type": "get",

"url": "/webvue_accueil/detail",

"title": "Detail Webvue accueil.",

"version": "0.1.0",

"name": "Detailwebvue_accueil",

"group": "webvue_accueil",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue accueils unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue accueils unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue accueil Cant be Accessed permission name : api_Webvue accueil_detail"

}

],

"parameter": {

"fields": {

"Parameter": [

{

"group": "Parameter",

"type": "Integer",

"optional": false,

"field": "Id",

"description": "<p>Mandatory id of Webvue accueils.</p>"

}

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

},

{

"group": "Success 200",

"type": "Array",

"optional": false,

"field": "Data",

"description": "<p>data of Webvue accueil.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "Webvue accueilNotFound",

"description": "<p>Webvue accueil data is not found.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue accueil.php",

"groupTitle": "Webvue accueil"

},

{

"type": "post",

"url": "/webvue_accueil/update",

"title": "Update Webvue accueil.",

"version": "0.1.0",

"name": "Updatewebvue_accueil",

"group": "webvue_accueil",

"header": {

"fields": {

"Header": [

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Api-Key",

"description": "<p>Webvue accueils unique access-key.</p>"

},

{

"group": "Header",

"type": "String",

"optional": false,

"field": "X-Token",

"description": "<p>Webvue accueils unique token.</p>"

}

]

}

},

"permission": [

{

"name": "Webvue accueil Cant be Accessed permission name : api_Webvue accueil_update"

}

],

"parameter": {

"fields": {

"Parameter": [

  {

  "group": "Parameter",

  "type": "String",

  "optional": true,

  "field": "Id",

  "description": "<p>Optional id of Webvue accueils .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Label",

  "description": "<p>Mandatory label of Webvue accueils .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Button",

  "description": "<p>Mandatory button of Webvue accueils Input Button Max Length : 100..</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Img_url",

  "description": "<p>Mandatory img_url of Webvue accueils .</p>"

  },

  {

  "group": "Parameter",

  "type": "String",

  "optional": false,

  "field": "Link",

  "description": "<p>Mandatory link of Webvue accueils .</p>"

  }

]

}

},

"success": {

"fields": {

"Success 200": [

{

"group": "Success 200",

"type": "Boolean",

"optional": false,

"field": "Status",

"description": "<p>status response api.</p>"

},

{

"group": "Success 200",

"type": "String",

"optional": false,

"field": "Message",

"description": "<p>message response api.</p>"

}

]

},

"examples": [

{

"title": "Success-Response:",

"content": "HTTP/1.1 200 OK",

"type": "json"

}

]

},

"error": {

"fields": {

"Error 4xx": [

{

"group": "Error 4xx",

"optional": false,

"field": "ValidationError",

"description": "<p>Error validation.</p>"

}

]

},

"examples": [

{

"title": "Error-Response:",

"content": "HTTP/1.1 403 Not Acceptable",

"type": "json"

}

]

},

"filename": "application/controllers/api/Webvue accueil.php",

"groupTitle": "Webvue accueil"

}] });
