<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_achat extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_achat');
	}

	/**
	 * @api {get} /agritun_achat/all Get all agritun_achats.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunachat 
	 * @apiGroup agritun_achat
	 * @apiHeader {String} X-Api-Key Agritun achats unique access-key.
	 * @apiHeader {String} X-Token Agritun achats unique token.
	 * @apiPermission Agritun achat Cant be Accessed permission name : api_agritun_achat_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun achats.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun achats : id, fournisseur, article, qte, prix_u, total, date, user_id, i_src, id_parcel.
	 * @apiParam {String} [Start=0] Optional start index of Agritun achats.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun achats.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_achat.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun achat Agritun achat data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_achat_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'fournisseur', 'article', 'qte', 'prix_u', 'total', 'date', 'user_id', 'i_src', 'id_parcel'];
		$agritun_achats = $this->model_api_agritun_achat->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_achat->count_all($filter, $field);
		$agritun_achats = array_map(function($row){
						
			return $row;
		}, $agritun_achats);

		$data['agritun_achat'] = $agritun_achats;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun achat',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /agritun_achat/detail Detail Agritun achat.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun achat
	 * @apiGroup agritun_achat
	 * @apiHeader {String} X-Api-Key Agritun achats unique access-key.
	 * @apiHeader {String} X-Token Agritun achats unique token.
	 * @apiPermission Agritun achat Cant be Accessed permission name : api_agritun_achat_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun achats.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_achat.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun achatNotFound Agritun achat data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_achat_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'fournisseur', 'article', 'qte', 'prix_u', 'total', 'date', 'user_id', 'i_src', 'id_parcel'];
		$agritun_achat = $this->model_api_agritun_achat->find($id, $select_field);

		if (!$agritun_achat) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['agritun_achat'] = $agritun_achat;
		if ($data['agritun_achat']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun achat',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun achat not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_achat/add Add Agritun achat.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun achat
	 * @apiGroup agritun_achat
	 * @apiHeader {String} X-Api-Key Agritun achats unique access-key.
	 * @apiHeader {String} X-Token Agritun achats unique token.
	 * @apiPermission Agritun achat Cant be Accessed permission name : api_agritun_achat_add
	 *
 	 * @apiParam {String} Fournisseur Mandatory fournisseur of Agritun achats. Input Fournisseur Max Length : 400. 
	 * @apiParam {String} Article Mandatory article of Agritun achats. Input Article Max Length : 300. 
	 * @apiParam {String} Qte Mandatory qte of Agritun achats. Input Qte Max Length : 300. 
	 * @apiParam {String} Prix_u Mandatory prix_u of Agritun achats. Input Prix U Max Length : 300. 
	 * @apiParam {String} Total Mandatory total of Agritun achats. Input Total Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun achats. Input User Id Max Length : 300. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun achats. Input I Src Max Length : 300. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun achats. Input Id Parcel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_achat_add');

		$this->form_validation->set_rules('fournisseur', 'Fournisseur', 'trim|required|max_length[400]');
		$this->form_validation->set_rules('article', 'Article', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte', 'Qte', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('prix_u', 'Prix U', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('total', 'Total', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'fournisseur' => $this->input->post('fournisseur'),
				'article' => $this->input->post('article'),
				'qte' => $this->input->post('qte'),
				'prix_u' => $this->input->post('prix_u'),
				'total' => $this->input->post('total'),
				'user_id' => $this->input->post('user_id'),
				'i_src' => $this->input->post('i_src'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_achat = $this->model_api_agritun_achat->store($save_data);

			if ($save_agritun_achat) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_achat/update Update Agritun achat.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun achat
	 * @apiGroup agritun_achat
	 * @apiHeader {String} X-Api-Key Agritun achats unique access-key.
	 * @apiHeader {String} X-Token Agritun achats unique token.
	 * @apiPermission Agritun achat Cant be Accessed permission name : api_agritun_achat_update
	 *
	 * @apiParam {String} Fournisseur Mandatory fournisseur of Agritun achats. Input Fournisseur Max Length : 400. 
	 * @apiParam {String} Article Mandatory article of Agritun achats. Input Article Max Length : 300. 
	 * @apiParam {String} Qte Mandatory qte of Agritun achats. Input Qte Max Length : 300. 
	 * @apiParam {String} Prix_u Mandatory prix_u of Agritun achats. Input Prix U Max Length : 300. 
	 * @apiParam {String} Total Mandatory total of Agritun achats. Input Total Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun achats. Input User Id Max Length : 300. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun achats. Input I Src Max Length : 300. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun achats. Input Id Parcel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Agritun Achat.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_achat_update');

		
		$this->form_validation->set_rules('fournisseur', 'Fournisseur', 'trim|required|max_length[400]');
		$this->form_validation->set_rules('article', 'Article', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte', 'Qte', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('prix_u', 'Prix U', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('total', 'Total', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'fournisseur' => $this->input->post('fournisseur'),
				'article' => $this->input->post('article'),
				'qte' => $this->input->post('qte'),
				'prix_u' => $this->input->post('prix_u'),
				'total' => $this->input->post('total'),
				'user_id' => $this->input->post('user_id'),
				'i_src' => $this->input->post('i_src'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_achat = $this->model_api_agritun_achat->change($this->post('id'), $save_data);

			if ($save_agritun_achat) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_achat/delete Delete Agritun achat. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun achat
	 * @apiGroup agritun_achat
	 * @apiHeader {String} X-Api-Key Agritun achats unique access-key.
	 * @apiHeader {String} X-Token Agritun achats unique token.
	 	 * @apiPermission Agritun achat Cant be Accessed permission name : api_agritun_achat_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun achats .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_achat_delete');

		$agritun_achat = $this->model_api_agritun_achat->find($this->post('id'));

		if (!$agritun_achat) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun achat not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_achat->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun achat deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun achat not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Agritun achat.php */
/* Location: ./application/controllers/api/Agritun achat.php */