<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Achat Controller
*| --------------------------------------------------------------------------
*| Agritun Achat site
*|
*/
class Agritun_achat extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_achat');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Achats
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_achat_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_achats'] = $this->model_agritun_achat->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_achat_counts'] = $this->model_agritun_achat->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_achat/index/',
			'total_rows'   => $this->data['agritun_achat_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Agritun Achat List');
		$this->render('backend/standart/administrator/agritun_achat/agritun_achat_list', $this->data);
	}
	
	/**
	* Add new agritun_achats
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_achat_add');

		$this->template->title('Agritun Achat New');
		$this->render('backend/standart/administrator/agritun_achat/agritun_achat_add', $this->data);
	}

	/**
	* Add New Agritun Achats
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_achat_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('fournisseur', 'البائع', 'trim|required|max_length[400]');
		

		$this->form_validation->set_rules('article', 'المنتوج', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte', 'الكمية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('prix_u', 'سعر الوحدة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('total', 'المجموع', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'fournisseur' => $this->input->post('fournisseur'),
				'article' => $this->input->post('article'),
				'qte' => $this->input->post('qte'),
				'prix_u' => $this->input->post('prix_u'),
				'total' => $this->input->post('total'),
				'user_id' => $this->input->post('user_id'),
				'i_src' => $this->input->post('i_src'),
			];

			
			
			$save_agritun_achat = $this->model_agritun_achat->store($save_data);
            

			if ($save_agritun_achat) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_achat;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_achat/edit/' . $save_agritun_achat, 'Edit Agritun Achat'),
						anchor('administrator/agritun_achat', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_achat/edit/' . $save_agritun_achat, 'Edit Agritun Achat')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_achat');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_achat');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Achats
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_achat_update');

		$this->data['agritun_achat'] = $this->model_agritun_achat->find($id);

		$this->template->title('Agritun Achat Update');
		$this->render('backend/standart/administrator/agritun_achat/agritun_achat_update', $this->data);
	}

	/**
	* Update Agritun Achats
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_achat_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('fournisseur', 'البائع', 'trim|required|max_length[400]');
		

		$this->form_validation->set_rules('article', 'المنتوج', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte', 'الكمية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('prix_u', 'سعر الوحدة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('total', 'المجموع', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'fournisseur' => $this->input->post('fournisseur'),
				'article' => $this->input->post('article'),
				'qte' => $this->input->post('qte'),
				'prix_u' => $this->input->post('prix_u'),
				'total' => $this->input->post('total'),
				'user_id' => $this->input->post('user_id'),
				'i_src' => $this->input->post('i_src'),
			];


			
			
			$save_agritun_achat = $this->model_agritun_achat->change($id, $save_data);

			if ($save_agritun_achat) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_achat', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_achat');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_achat');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Achats
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_achat_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_achat'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_achat'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Achats
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_achat_view');

		$this->data['agritun_achat'] = $this->model_agritun_achat->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Agritun Achat Detail');
		$this->render('backend/standart/administrator/agritun_achat/agritun_achat_view', $this->data);
	}
	
	/**
	* delete Agritun Achats
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_achat = $this->model_agritun_achat->find($id);

		
		
		return $this->model_agritun_achat->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_achat_export');

		$this->model_agritun_achat->export(
			'agritun_achat', 
			'agritun_achat',
			$this->model_agritun_achat->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_achat_export');

		$this->model_agritun_achat->pdf('agritun_achat', 'agritun_achat');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_achat_export');

		$table = $title = 'agritun_achat';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_achat->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_achat.php */
/* Location: ./application/controllers/administrator/Agritun Achat.php */