<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_masra extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_masra');
	}

	/**
	 * @api {get} /agritun_masra/all Get all agritun_masras.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunmasra 
	 * @apiGroup agritun_masra
	 * @apiHeader {String} X-Api-Key Agritun masras unique access-key.
	 * @apiHeader {String} X-Token Agritun masras unique token.
	 * @apiPermission Agritun masra Cant be Accessed permission name : api_agritun_masra_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun masras.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun masras : id, name, region, tel, date, user_id.
	 * @apiParam {String} [Start=0] Optional start index of Agritun masras.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun masras.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_masra.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun masra Agritun masra data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_masra_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'name', 'region', 'tel', 'date', 'user_id'];
		$agritun_masras = $this->model_api_agritun_masra->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_masra->count_all($filter, $field);
		$agritun_masras = array_map(function($row){
			
			
			return $row;
		}, $agritun_masras);

		$data['agritun_masra'] = $agritun_masras;
		
		
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun masra',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

	
	/**
	 * @api {get} /agritun_masra/detail Detail Agritun masra.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun masra
	 * @apiGroup agritun_masra
	 * @apiHeader {String} X-Api-Key Agritun masras unique access-key.
	 * @apiHeader {String} X-Token Agritun masras unique token.
	 * @apiPermission Agritun masra Cant be Accessed permission name : api_agritun_masra_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun masras.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_masra.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun masraNotFound Agritun masra data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_masra_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'name', 'region', 'tel', 'date', 'user_id'];
		$agritun_masra = $this->model_api_agritun_masra->find($id, $select_field);

		if (!$agritun_masra) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

		
			
		$data['agritun_masra'] = $agritun_masra;
		if ($data['agritun_masra']) {
			

			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun masra',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_masra/add Add Agritun masra.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun masra
	 * @apiGroup agritun_masra
	 * @apiHeader {String} X-Api-Key Agritun masras unique access-key.
	 * @apiHeader {String} X-Token Agritun masras unique token.
	 * @apiPermission Agritun masra Cant be Accessed permission name : api_agritun_masra_add
	 *
 	 * @apiParam {String} Name Mandatory name of Agritun masras. Input Name Max Length : 300. 
	 * @apiParam {String} Region Mandatory region of Agritun masras. Input Region Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Agritun masras. Input Tel Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun masras. Input User Id Max Length : 11. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_masra_add');

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('region', 'Region', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'name' => $this->input->post('name'),

			
	'region' => $this->input->post('region'),

			
	'tel' => $this->input->post('tel'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_masra = $this->model_api_agritun_masra->store($save_data);

			if ($save_agritun_masra) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_masra/update Update Agritun masra.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun masra
	 * @apiGroup agritun_masra
	 * @apiHeader {String} X-Api-Key Agritun masras unique access-key.
	 * @apiHeader {String} X-Token Agritun masras unique token.
	 * @apiPermission Agritun masra Cant be Accessed permission name : api_agritun_masra_update
	 *
	 * @apiParam {String} Name Mandatory name of Agritun masras. Input Name Max Length : 300. 
	 * @apiParam {String} Region Mandatory region of Agritun masras. Input Region Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Agritun masras. Input Tel Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun masras. Input User Id Max Length : 11. 
	 * @apiParam {Integer} id Mandatory id of Agritun Masra.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_masra_update');

		
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('region', 'Region', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'name' => $this->input->post('name'),

			
	'region' => $this->input->post('region'),

			
	'tel' => $this->input->post('tel'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_masra = $this->model_api_agritun_masra->change($this->post('id'), $save_data);

			if ($save_agritun_masra) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_masra/delete Delete Agritun masra. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun masra
	 * @apiGroup agritun_masra
	 * @apiHeader {String} X-Api-Key Agritun masras unique access-key.
	 * @apiHeader {String} X-Token Agritun masras unique token.
	 
	 * @apiPermission Agritun masra Cant be Accessed permission name : api_agritun_masra_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun masras .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_masra_delete');

		$agritun_masra = $this->model_api_agritun_masra->find($this->post('id'));

		if (!$agritun_masra) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_masra->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun masra deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	

}

/* End of file Agritun masra.php */
/* Location: ./application/controllers/api/Agritun masra.php */