<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Masra Controller
*| --------------------------------------------------------------------------
*| Agritun Masra site
*|
*/
class Agritun_masra extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_masra');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Masras
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_masra_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_masras'] = $this->model_agritun_masra->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_masra_counts'] = $this->model_agritun_masra->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_masra/index/',
			'total_rows'   => $this->data['agritun_masra_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('قائمة المعاصر List');
		$this->render('backend/standart/administrator/agritun_masra/agritun_masra_list', $this->data);
	}
	
	/**
	* Add new agritun_masras
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_masra_add');

		$this->template->title('قائمة المعاصر New');
		$this->render('backend/standart/administrator/agritun_masra/agritun_masra_add', $this->data);
	}

	/**
	* Add New Agritun Masras
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_masra_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('name', 'الاسم', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('region', 'الولاية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('tel', 'رقم الهاتف', 'trim|required|max_length[300]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'region' => $this->input->post('region'),
				'tel' => $this->input->post('tel'),
				'date' => date('Y-m-d H:i:s'),
			];

			
			
			$save_agritun_masra = $this->model_agritun_masra->store($save_data);
            

			if ($save_agritun_masra) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_masra;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_masra/edit/' . $save_agritun_masra, 'Edit Agritun Masra'),
						anchor('administrator/agritun_masra', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_masra/edit/' . $save_agritun_masra, 'Edit Agritun Masra')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_masra');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_masra');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Masras
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_masra_update');

		$this->data['agritun_masra'] = $this->model_agritun_masra->find($id);

		$this->template->title('قائمة المعاصر Update');
		$this->render('backend/standart/administrator/agritun_masra/agritun_masra_update', $this->data);
	}

	/**
	* Update Agritun Masras
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_masra_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('name', 'الاسم', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('region', 'الولاية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('tel', 'رقم الهاتف', 'trim|required|max_length[300]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'region' => $this->input->post('region'),
				'tel' => $this->input->post('tel'),
				'date' => date('Y-m-d H:i:s'),
			];


			
			
			$save_agritun_masra = $this->model_agritun_masra->change($id, $save_data);

			if ($save_agritun_masra) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_masra', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_masra');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_masra');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Masras
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_masra_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_masra'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_masra'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Masras
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_masra_view');

		$this->data['agritun_masra'] = $this->model_agritun_masra->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('قائمة المعاصر Detail');
		$this->render('backend/standart/administrator/agritun_masra/agritun_masra_view', $this->data);
	}
	
	/**
	* delete Agritun Masras
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_masra = $this->model_agritun_masra->find($id);

		
		
		return $this->model_agritun_masra->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_masra_export');

		$this->model_agritun_masra->export(
			'agritun_masra', 
			'agritun_masra',
			$this->model_agritun_masra->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_masra_export');

		$this->model_agritun_masra->pdf('agritun_masra', 'agritun_masra');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_masra_export');

		$table = $title = 'agritun_masra';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_masra->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_masra.php */
/* Location: ./application/controllers/administrator/Agritun Masra.php */