<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_masra_entrant extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_masra_entrant');
	}

	/**
	 * @api {get} /agritun_masra_entrant/all Get all agritun_masra_entrants.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunmasraentrant 
	 * @apiGroup agritun_masra_entrant
	 * @apiHeader {String} X-Api-Key Agritun masra entrants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra entrants unique token.
	 * @apiPermission Agritun masra entrant Cant be Accessed permission name : api_agritun_masra_entrant_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun masra entrants.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun masra entrants : id, masra, qualite, quantite, date, i_src, user_id, id_parcel.
	 * @apiParam {String} [Start=0] Optional start index of Agritun masra entrants.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun masra entrants.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_masra_entrant.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun masra entrant Agritun masra entrant data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_masra_entrant_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'masra', 'qualite', 'quantite', 'date', 'i_src', 'user_id', 'id_parcel'];
		$agritun_masra_entrants = $this->model_api_agritun_masra_entrant->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_masra_entrant->count_all($filter, $field);
		$agritun_masra_entrants = array_map(function($row){
						
			return $row;
		}, $agritun_masra_entrants);

		$data['agritun_masra_entrant'] = $agritun_masra_entrants;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun masra entrant',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /agritun_masra_entrant/detail Detail Agritun masra entrant.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun masra entrant
	 * @apiGroup agritun_masra_entrant
	 * @apiHeader {String} X-Api-Key Agritun masra entrants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra entrants unique token.
	 * @apiPermission Agritun masra entrant Cant be Accessed permission name : api_agritun_masra_entrant_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun masra entrants.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_masra_entrant.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun masra entrantNotFound Agritun masra entrant data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_masra_entrant_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'masra', 'qualite', 'quantite', 'date', 'i_src', 'user_id', 'id_parcel'];
		$agritun_masra_entrant = $this->model_api_agritun_masra_entrant->find($id, $select_field);

		if (!$agritun_masra_entrant) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['agritun_masra_entrant'] = $agritun_masra_entrant;
		if ($data['agritun_masra_entrant']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun masra entrant',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra entrant not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_masra_entrant/add Add Agritun masra entrant.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun masra entrant
	 * @apiGroup agritun_masra_entrant
	 * @apiHeader {String} X-Api-Key Agritun masra entrants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra entrants unique token.
	 * @apiPermission Agritun masra entrant Cant be Accessed permission name : api_agritun_masra_entrant_add
	 *
 	 * @apiParam {String} Masra Mandatory masra of Agritun masra entrants. Input Masra Max Length : 300. 
	 * @apiParam {String} Qualite Mandatory qualite of Agritun masra entrants. Input Qualite Max Length : 300. 
	 * @apiParam {String} Quantite Mandatory quantite of Agritun masra entrants. Input Quantite Max Length : 300. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun masra entrants. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun masra entrants. Input User Id Max Length : 11. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun masra entrants. Input Id Parcel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_masra_entrant_add');

		$this->form_validation->set_rules('masra', 'Masra', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite', 'Qualite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('quantite', 'Quantite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'masra' => $this->input->post('masra'),
				'qualite' => $this->input->post('qualite'),
				'quantite' => $this->input->post('quantite'),
				'i_src' => $this->input->post('i_src'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_masra_entrant = $this->model_api_agritun_masra_entrant->store($save_data);

			if ($save_agritun_masra_entrant) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_masra_entrant/update Update Agritun masra entrant.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun masra entrant
	 * @apiGroup agritun_masra_entrant
	 * @apiHeader {String} X-Api-Key Agritun masra entrants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra entrants unique token.
	 * @apiPermission Agritun masra entrant Cant be Accessed permission name : api_agritun_masra_entrant_update
	 *
	 * @apiParam {String} Masra Mandatory masra of Agritun masra entrants. Input Masra Max Length : 300. 
	 * @apiParam {String} Qualite Mandatory qualite of Agritun masra entrants. Input Qualite Max Length : 300. 
	 * @apiParam {String} Quantite Mandatory quantite of Agritun masra entrants. Input Quantite Max Length : 300. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun masra entrants. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun masra entrants. Input User Id Max Length : 11. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun masra entrants. Input Id Parcel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Agritun Masra Entrant.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_masra_entrant_update');

		
		$this->form_validation->set_rules('masra', 'Masra', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite', 'Qualite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('quantite', 'Quantite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'masra' => $this->input->post('masra'),
				'qualite' => $this->input->post('qualite'),
				'quantite' => $this->input->post('quantite'),
				'i_src' => $this->input->post('i_src'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_masra_entrant = $this->model_api_agritun_masra_entrant->change($this->post('id'), $save_data);

			if ($save_agritun_masra_entrant) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_masra_entrant/delete Delete Agritun masra entrant. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun masra entrant
	 * @apiGroup agritun_masra_entrant
	 * @apiHeader {String} X-Api-Key Agritun masra entrants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra entrants unique token.
	 	 * @apiPermission Agritun masra entrant Cant be Accessed permission name : api_agritun_masra_entrant_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun masra entrants .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_masra_entrant_delete');

		$agritun_masra_entrant = $this->model_api_agritun_masra_entrant->find($this->post('id'));

		if (!$agritun_masra_entrant) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra entrant not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_masra_entrant->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun masra entrant deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra entrant not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Agritun masra entrant.php */
/* Location: ./application/controllers/api/Agritun masra entrant.php */