<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Masra Entrant Controller
*| --------------------------------------------------------------------------
*| Agritun Masra Entrant site
*|
*/
class Agritun_masra_entrant extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_masra_entrant');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Masra Entrants
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_masra_entrant_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_masra_entrants'] = $this->model_agritun_masra_entrant->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_masra_entrant_counts'] = $this->model_agritun_masra_entrant->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_masra_entrant/index/',
			'total_rows'   => $this->data['agritun_masra_entrant_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('تزويد المعصرة بالزيتون List');
		$this->render('backend/standart/administrator/agritun_masra_entrant/agritun_masra_entrant_list', $this->data);
	}
	
	/**
	* Add new agritun_masra_entrants
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_masra_entrant_add');

		$this->template->title('تزويد المعصرة بالزيتون New');
		$this->render('backend/standart/administrator/agritun_masra_entrant/agritun_masra_entrant_add', $this->data);
	}

	/**
	* Add New Agritun Masra Entrants
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_masra_entrant_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('masra', 'المعصرة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qualite', 'نوع الزيتون', 'trim|required');
		

		$this->form_validation->set_rules('quantite', 'الكمية', 'trim|required|max_length[300]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'masra' => $this->input->post('masra'),
				'qualite' => $this->input->post('qualite'),
				'quantite' => $this->input->post('quantite'),
				'date' => date('Y-m-d H:i:s'),
				'i_src' => $this->input->post('i_src'),
			];

			
			
			$save_agritun_masra_entrant = $this->model_agritun_masra_entrant->store($save_data);
            

			if ($save_agritun_masra_entrant) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_masra_entrant;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_masra_entrant/edit/' . $save_agritun_masra_entrant, 'Edit Agritun Masra Entrant'),
						anchor('administrator/agritun_masra_entrant', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_masra_entrant/edit/' . $save_agritun_masra_entrant, 'Edit Agritun Masra Entrant')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_masra_entrant');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_masra_entrant');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Masra Entrants
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_masra_entrant_update');

		$this->data['agritun_masra_entrant'] = $this->model_agritun_masra_entrant->find($id);

		$this->template->title('تزويد المعصرة بالزيتون Update');
		$this->render('backend/standart/administrator/agritun_masra_entrant/agritun_masra_entrant_update', $this->data);
	}

	/**
	* Update Agritun Masra Entrants
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_masra_entrant_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('masra', 'المعصرة', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qualite', 'نوع الزيتون', 'trim|required');
		

		$this->form_validation->set_rules('quantite', 'الكمية', 'trim|required|max_length[300]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'masra' => $this->input->post('masra'),
				'qualite' => $this->input->post('qualite'),
				'quantite' => $this->input->post('quantite'),
				'date' => date('Y-m-d H:i:s'),
				'i_src' => $this->input->post('i_src'),
			];


			
			
			$save_agritun_masra_entrant = $this->model_agritun_masra_entrant->change($id, $save_data);

			if ($save_agritun_masra_entrant) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_masra_entrant', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_masra_entrant');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_masra_entrant');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Masra Entrants
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_masra_entrant_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_masra_entrant'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_masra_entrant'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Masra Entrants
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_masra_entrant_view');

		$this->data['agritun_masra_entrant'] = $this->model_agritun_masra_entrant->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('تزويد المعصرة بالزيتون Detail');
		$this->render('backend/standart/administrator/agritun_masra_entrant/agritun_masra_entrant_view', $this->data);
	}
	
	/**
	* delete Agritun Masra Entrants
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_masra_entrant = $this->model_agritun_masra_entrant->find($id);

		
		
		return $this->model_agritun_masra_entrant->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_masra_entrant_export');

		$this->model_agritun_masra_entrant->export(
			'agritun_masra_entrant', 
			'agritun_masra_entrant',
			$this->model_agritun_masra_entrant->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_masra_entrant_export');

		$this->model_agritun_masra_entrant->pdf('agritun_masra_entrant', 'agritun_masra_entrant');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_masra_entrant_export');

		$table = $title = 'agritun_masra_entrant';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_masra_entrant->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_masra_entrant.php */
/* Location: ./application/controllers/administrator/Agritun Masra Entrant.php */