<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_masra_sortant extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_masra_sortant');
	}

	/**
	 * @api {get} /agritun_masra_sortant/all Get all agritun_masra_sortants.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunmasrasortant 
	 * @apiGroup agritun_masra_sortant
	 * @apiHeader {String} X-Api-Key Agritun masra sortants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra sortants unique token.
	 * @apiPermission Agritun masra sortant Cant be Accessed permission name : api_agritun_masra_sortant_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun masra sortants.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun masra sortants : id, masra, qte_zitoun, prix_u, qte_zit, qualite, cout, date, qualite_zit, i_src, user_id, id_parcel.
	 * @apiParam {String} [Start=0] Optional start index of Agritun masra sortants.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun masra sortants.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_masra_sortant.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun masra sortant Agritun masra sortant data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_masra_sortant_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'masra', 'qte_zitoun', 'prix_u', 'qte_zit', 'qualite', 'cout', 'date', 'qualite_zit', 'i_src', 'user_id', 'id_parcel'];
		$agritun_masra_sortants = $this->model_api_agritun_masra_sortant->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_masra_sortant->count_all($filter, $field);
		$agritun_masra_sortants = array_map(function($row){
						
			return $row;
		}, $agritun_masra_sortants);

		$data['agritun_masra_sortant'] = $agritun_masra_sortants;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun masra sortant',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /agritun_masra_sortant/detail Detail Agritun masra sortant.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun masra sortant
	 * @apiGroup agritun_masra_sortant
	 * @apiHeader {String} X-Api-Key Agritun masra sortants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra sortants unique token.
	 * @apiPermission Agritun masra sortant Cant be Accessed permission name : api_agritun_masra_sortant_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun masra sortants.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_masra_sortant.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun masra sortantNotFound Agritun masra sortant data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_masra_sortant_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'masra', 'qte_zitoun', 'prix_u', 'qte_zit', 'qualite', 'cout', 'date', 'qualite_zit', 'i_src', 'user_id', 'id_parcel'];
		$agritun_masra_sortant = $this->model_api_agritun_masra_sortant->find($id, $select_field);

		if (!$agritun_masra_sortant) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['agritun_masra_sortant'] = $agritun_masra_sortant;
		if ($data['agritun_masra_sortant']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun masra sortant',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra sortant not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_masra_sortant/add Add Agritun masra sortant.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun masra sortant
	 * @apiGroup agritun_masra_sortant
	 * @apiHeader {String} X-Api-Key Agritun masra sortants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra sortants unique token.
	 * @apiPermission Agritun masra sortant Cant be Accessed permission name : api_agritun_masra_sortant_add
	 *
 	 * @apiParam {String} Masra Mandatory masra of Agritun masra sortants. Input Masra Max Length : 300. 
	 * @apiParam {String} Qte_zitoun Mandatory qte_zitoun of Agritun masra sortants. Input Qte Zitoun Max Length : 300. 
	 * @apiParam {String} Prix_u Mandatory prix_u of Agritun masra sortants. Input Prix U Max Length : 300. 
	 * @apiParam {String} Qte_zit Mandatory qte_zit of Agritun masra sortants. Input Qte Zit Max Length : 300. 
	 * @apiParam {String} Qualite Mandatory qualite of Agritun masra sortants. Input Qualite Max Length : 300. 
	 * @apiParam {String} Cout Mandatory cout of Agritun masra sortants. Input Cout Max Length : 300. 
	 * @apiParam {String} Qualite_zit Mandatory qualite_zit of Agritun masra sortants. Input Qualite Zit Max Length : 300. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun masra sortants. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun masra sortants. Input User Id Max Length : 11. 
	 * @apiParam {String} Id_parcel Mandatory id_parcel of Agritun masra sortants. Input Id Parcel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_masra_sortant_add');

		$this->form_validation->set_rules('masra', 'Masra', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte_zitoun', 'Qte Zitoun', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('prix_u', 'Prix U', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte_zit', 'Qte Zit', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite', 'Qualite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('cout', 'Cout', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite_zit', 'Qualite Zit', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|required|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'masra' => $this->input->post('masra'),
				'qte_zitoun' => $this->input->post('qte_zitoun'),
				'prix_u' => $this->input->post('prix_u'),
				'qte_zit' => $this->input->post('qte_zit'),
				'qualite' => $this->input->post('qualite'),
				'cout' => $this->input->post('cout'),
				'qualite_zit' => $this->input->post('qualite_zit'),
				'i_src' => $this->input->post('i_src'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_masra_sortant = $this->model_api_agritun_masra_sortant->store($save_data);

			if ($save_agritun_masra_sortant) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_masra_sortant/update Update Agritun masra sortant.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun masra sortant
	 * @apiGroup agritun_masra_sortant
	 * @apiHeader {String} X-Api-Key Agritun masra sortants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra sortants unique token.
	 * @apiPermission Agritun masra sortant Cant be Accessed permission name : api_agritun_masra_sortant_update
	 *
	 * @apiParam {String} Masra Mandatory masra of Agritun masra sortants. Input Masra Max Length : 300. 
	 * @apiParam {String} Qte_zitoun Mandatory qte_zitoun of Agritun masra sortants. Input Qte Zitoun Max Length : 300. 
	 * @apiParam {String} Prix_u Mandatory prix_u of Agritun masra sortants. Input Prix U Max Length : 300. 
	 * @apiParam {String} Qte_zit Mandatory qte_zit of Agritun masra sortants. Input Qte Zit Max Length : 300. 
	 * @apiParam {String} Qualite Mandatory qualite of Agritun masra sortants. Input Qualite Max Length : 300. 
	 * @apiParam {String} Cout Mandatory cout of Agritun masra sortants. Input Cout Max Length : 300. 
	 * @apiParam {String} Qualite_zit Mandatory qualite_zit of Agritun masra sortants. Input Qualite Zit Max Length : 300. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun masra sortants. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun masra sortants. Input User Id Max Length : 11. 
	 * @apiParam {String} Id_parcel Mandatory id_parcel of Agritun masra sortants. Input Id Parcel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Agritun Masra Sortant.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_masra_sortant_update');

		
		$this->form_validation->set_rules('masra', 'Masra', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte_zitoun', 'Qte Zitoun', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('prix_u', 'Prix U', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qte_zit', 'Qte Zit', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite', 'Qualite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('cout', 'Cout', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite_zit', 'Qualite Zit', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|required|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'masra' => $this->input->post('masra'),
				'qte_zitoun' => $this->input->post('qte_zitoun'),
				'prix_u' => $this->input->post('prix_u'),
				'qte_zit' => $this->input->post('qte_zit'),
				'qualite' => $this->input->post('qualite'),
				'cout' => $this->input->post('cout'),
				'qualite_zit' => $this->input->post('qualite_zit'),
				'i_src' => $this->input->post('i_src'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_masra_sortant = $this->model_api_agritun_masra_sortant->change($this->post('id'), $save_data);

			if ($save_agritun_masra_sortant) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_masra_sortant/delete Delete Agritun masra sortant. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun masra sortant
	 * @apiGroup agritun_masra_sortant
	 * @apiHeader {String} X-Api-Key Agritun masra sortants unique access-key.
	 * @apiHeader {String} X-Token Agritun masra sortants unique token.
	 	 * @apiPermission Agritun masra sortant Cant be Accessed permission name : api_agritun_masra_sortant_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun masra sortants .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_masra_sortant_delete');

		$agritun_masra_sortant = $this->model_api_agritun_masra_sortant->find($this->post('id'));

		if (!$agritun_masra_sortant) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra sortant not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_masra_sortant->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun masra sortant deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun masra sortant not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Agritun masra sortant.php */
/* Location: ./application/controllers/api/Agritun masra sortant.php */