<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_agritun_recolte extends MY_Model {

    private $primary_key    = 'id';
    private $table_name     = 'agritun_recolte';
    public $field_search   = ['date', 'id_parcel', 'id_equipe', 'mode_paiement', 'nbr_pieds', 'hay', 'nchira', 'q_unite', 'q_prix', 'h_prix', 'f_prix', 'h_nbr', 'f_nbr', 'cout', 'i_src'];

    public function __construct()
    {
        $config = array(
            'primary_key'   => $this->primary_key,
            'table_name'    => $this->table_name,
            'field_search'  => $this->field_search,
         );

        parent::__construct($config);
    }

    public function count_all($q = null, $field = null)
    {
        $iterasi = 1;
        $num = count($this->field_search);
        $where = NULL;
        $q = $this->scurity($q);
        $field = $this->scurity($field);

        if (empty($field)) {
            foreach ($this->field_search as $field) {
                if ($iterasi == 1) {
                    $where .= "agritun_recolte.".$field . " LIKE '%" . $q . "%' ";
                } else {
                    $where .= "OR " . "agritun_recolte.".$field . " LIKE '%" . $q . "%' ";
                }
                $iterasi++;
            }

            $where = '('.$where.')';
        } else {
            $where .= "(" . "agritun_recolte.".$field . " LIKE '%" . $q . "%' )";
        }

        $this->join_avaiable()->filter_avaiable();
        $this->db->where($where);
        $query = $this->db->get($this->table_name);

        return $query->num_rows();
    }

    public function get($q = null, $field = null, $limit = 0, $offset = 0, $select_field = [])
    {
        $iterasi = 1;
        $num = count($this->field_search);
        $where = NULL;
        $q = $this->scurity($q);
        $field = $this->scurity($field);

        if (empty($field)) {
            foreach ($this->field_search as $field) {
                if ($iterasi == 1) {
                    $where .= "agritun_recolte.".$field . " LIKE '%" . $q . "%' ";
                } else {
                    $where .= "OR " . "agritun_recolte.".$field . " LIKE '%" . $q . "%' ";
                }
                $iterasi++;
            }

            $where = '('.$where.')';
        } else {
            $where .= "(" . "agritun_recolte.".$field . " LIKE '%" . $q . "%' )";
        }

        if (is_array($select_field) AND count($select_field)) {
            $this->db->select($select_field);
        }
        
        $this->join_avaiable()->filter_avaiable();
        $this->db->where($where);
        $this->db->limit($limit, $offset);
        
        $this->sortable();
        
        $query = $this->db->get($this->table_name);

        return $query->result();
    }

    public function join_avaiable() {
        $this->db->join('parcels', 'parcels.id = agritun_recolte.id_parcel', 'LEFT');
        $this->db->join('agritun_team', 'agritun_team.id = agritun_recolte.id_equipe', 'LEFT');
        $this->db->join('agritun_team agritun_team1', 'agritun_team1.mode_paiement = agritun_recolte.mode_paiement', 'LEFT');
        
        $this->db->select('agritun_recolte.*,parcels.name as parcels_name,agritun_team.team_name as agritun_team_team_name,agritun_team.mode_paiement as agritun_team_mode_paiement');


        return $this;
    }

    public function filter_avaiable() {

        if (!$this->aauth->is_admin()) {
            $this->db->where($this->table_name.'.id_utilisateur', get_user_data('id'));
        }

        return $this;
    }

}

/* End of file Model_agritun_recolte.php */
/* Location: ./application/models/Model_agritun_recolte.php */