<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_team extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_team');
	}

	/**
	 * @api {get} /agritun_team/all Get all agritun_teams.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunteam 
	 * @apiGroup agritun_team
	 * @apiHeader {String} X-Api-Key Agritun teams unique access-key.
	 * @apiHeader {String} X-Token Agritun teams unique token.
	 * @apiPermission Agritun team Cant be Accessed permission name : api_agritun_team_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun teams.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun teams : id, team_name, mode_paiement, h_prix, f_prix, h_nbr, f_nbr, q_unite, q_prix, mode_culture, tel, user_id.
	 * @apiParam {String} [Start=0] Optional start index of Agritun teams.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun teams.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_team.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun team Agritun team data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_team_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'team_name', 'mode_paiement', 'h_prix', 'f_prix', 'h_nbr', 'f_nbr', 'q_unite', 'q_prix', 'mode_culture', 'tel', 'user_id'];
		$agritun_teams = $this->model_api_agritun_team->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_team->count_all($filter, $field);
		$agritun_teams = array_map(function($row){
			
			
			return $row;
		}, $agritun_teams);

		$data['agritun_team'] = $agritun_teams;
		
		
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun team',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

	
	/**
	 * @api {get} /agritun_team/detail Detail Agritun team.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun team
	 * @apiGroup agritun_team
	 * @apiHeader {String} X-Api-Key Agritun teams unique access-key.
	 * @apiHeader {String} X-Token Agritun teams unique token.
	 * @apiPermission Agritun team Cant be Accessed permission name : api_agritun_team_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun teams.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_team.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun teamNotFound Agritun team data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_team_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'team_name', 'mode_paiement', 'h_prix', 'f_prix', 'h_nbr', 'f_nbr', 'q_unite', 'q_prix', 'mode_culture', 'tel', 'user_id'];
		$agritun_team = $this->model_api_agritun_team->find($id, $select_field);

		if (!$agritun_team) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

		
			
		$data['agritun_team'] = $agritun_team;
		if ($data['agritun_team']) {
			

			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun team',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun team not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_team/add Add Agritun team.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun team
	 * @apiGroup agritun_team
	 * @apiHeader {String} X-Api-Key Agritun teams unique access-key.
	 * @apiHeader {String} X-Token Agritun teams unique token.
	 * @apiPermission Agritun team Cant be Accessed permission name : api_agritun_team_add
	 *
 	 * @apiParam {String} Team_name Mandatory team_name of Agritun teams. Input Team Name Max Length : 300. 
	 * @apiParam {String} Mode_paiement Mandatory mode_paiement of Agritun teams. Input Mode Paiement Max Length : 300. 
	 * @apiParam {String} [H_prix] Optional h_prix of Agritun teams. Input H Prix Max Length : 300. 
	 * @apiParam {String} [F_prix] Optional f_prix of Agritun teams. Input F Prix Max Length : 300. 
	 * @apiParam {String} [H_nbr] Optional h_nbr of Agritun teams. Input H Nbr Max Length : 300. 
	 * @apiParam {String} [F_nbr] Optional f_nbr of Agritun teams. Input F Nbr Max Length : 300. 
	 * @apiParam {String} Q_unite Mandatory q_unite of Agritun teams. Input Q Unite Max Length : 300. 
	 * @apiParam {String} [Q_prix] Optional q_prix of Agritun teams. Input Q Prix Max Length : 300. 
	 * @apiParam {String} Mode_culture Mandatory mode_culture of Agritun teams. Input Mode Culture Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Agritun teams. Input Tel Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun teams. Input User Id Max Length : 11. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_team_add');

		$this->form_validation->set_rules('team_name', 'Team Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('mode_paiement', 'Mode Paiement', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('h_prix', 'H Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_prix', 'F Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('h_nbr', 'H Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_nbr', 'F Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('q_unite', 'Q Unite', 'trim|max_length[300]|required');
		$this->form_validation->set_rules('q_prix', 'Q Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('mode_culture', 'Mode Culture', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'team_name' => $this->input->post('team_name'),

			
	'mode_paiement' => $this->input->post('mode_paiement'),

			
	'h_prix' => $this->input->post('h_prix'),

			
	'f_prix' => $this->input->post('f_prix'),

			
	'h_nbr' => $this->input->post('h_nbr'),

			
	'f_nbr' => $this->input->post('f_nbr'),

			
	'q_unite' => $this->input->post('q_unite'),

			
	'q_prix' => $this->input->post('q_prix'),

			
	'mode_culture' => $this->input->post('mode_culture'),

			
	'tel' => $this->input->post('tel'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_team = $this->model_api_agritun_team->store($save_data);

			if ($save_agritun_team) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_team/update Update Agritun team.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun team
	 * @apiGroup agritun_team
	 * @apiHeader {String} X-Api-Key Agritun teams unique access-key.
	 * @apiHeader {String} X-Token Agritun teams unique token.
	 * @apiPermission Agritun team Cant be Accessed permission name : api_agritun_team_update
	 *
	 * @apiParam {String} Team_name Mandatory team_name of Agritun teams. Input Team Name Max Length : 300. 
	 * @apiParam {String} Mode_paiement Mandatory mode_paiement of Agritun teams. Input Mode Paiement Max Length : 300. 
	 * @apiParam {String} [H_prix] Optional h_prix of Agritun teams. Input H Prix Max Length : 300. 
	 * @apiParam {String} [F_prix] Optional f_prix of Agritun teams. Input F Prix Max Length : 300. 
	 * @apiParam {String} [H_nbr] Optional h_nbr of Agritun teams. Input H Nbr Max Length : 300. 
	 * @apiParam {String} [F_nbr] Optional f_nbr of Agritun teams. Input F Nbr Max Length : 300. 
	 * @apiParam {String} Q_unite Mandatory q_unite of Agritun teams. Input Q Unite Max Length : 300. 
	 * @apiParam {String} [Q_prix] Optional q_prix of Agritun teams. Input Q Prix Max Length : 300. 
	 * @apiParam {String} Mode_culture Mandatory mode_culture of Agritun teams. Input Mode Culture Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Agritun teams. Input Tel Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun teams. Input User Id Max Length : 11. 
	 * @apiParam {Integer} id Mandatory id of Agritun Team.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_team_update');

		
		$this->form_validation->set_rules('team_name', 'Team Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('mode_paiement', 'Mode Paiement', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('h_prix', 'H Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_prix', 'F Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('h_nbr', 'H Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('f_nbr', 'F Nbr', 'trim|max_length[300]');
		$this->form_validation->set_rules('q_unite', 'Q Unite', 'trim|max_length[300]|required');
		$this->form_validation->set_rules('q_prix', 'Q Prix', 'trim|max_length[300]');
		$this->form_validation->set_rules('mode_culture', 'Mode Culture', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'team_name' => $this->input->post('team_name'),

			
	'mode_paiement' => $this->input->post('mode_paiement'),

			
	'h_prix' => $this->input->post('h_prix'),

			
	'f_prix' => $this->input->post('f_prix'),

			
	'h_nbr' => $this->input->post('h_nbr'),

			
	'f_nbr' => $this->input->post('f_nbr'),

			
	'q_unite' => $this->input->post('q_unite'),

			
	'q_prix' => $this->input->post('q_prix'),

			
	'mode_culture' => $this->input->post('mode_culture'),

			
	'tel' => $this->input->post('tel'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_agritun_team = $this->model_api_agritun_team->change($this->post('id'), $save_data);

			if ($save_agritun_team) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_team/delete Delete Agritun team. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun team
	 * @apiGroup agritun_team
	 * @apiHeader {String} X-Api-Key Agritun teams unique access-key.
	 * @apiHeader {String} X-Token Agritun teams unique token.
	 
	 * @apiPermission Agritun team Cant be Accessed permission name : api_agritun_team_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun teams .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_team_delete');

		$agritun_team = $this->model_api_agritun_team->find($this->post('id'));

		if (!$agritun_team) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun team not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_team->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun team deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun team not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	

}

/* End of file Agritun team.php */
/* Location: ./application/controllers/api/Agritun team.php */