<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Agritun Transport Controller
*| --------------------------------------------------------------------------
*| Agritun Transport site
*|
*/
class Agritun_transport extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_agritun_transport');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Agritun Transports
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('agritun_transport_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['agritun_transports'] = $this->model_agritun_transport->get($filter, $field, $this->limit_page, $offset);
		$this->data['agritun_transport_counts'] = $this->model_agritun_transport->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/agritun_transport/index/',
			'total_rows'   => $this->data['agritun_transport_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('عمليات التوصيل List');
		$this->render('backend/standart/administrator/agritun_transport/agritun_transport_list', $this->data);
	}
	
	/**
	* Add new agritun_transports
	*
	*/
	public function add()
	{
		$this->is_allowed('agritun_transport_add');

		$this->template->title('عمليات التوصيل New');
		$this->render('backend/standart/administrator/agritun_transport/agritun_transport_add', $this->data);
	}

	/**
	* Add New Agritun Transports
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('agritun_transport_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('id_transporteur', 'السائق', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte', 'الكمية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte_unite', 'وحدة القيس', 'trim|required');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'id_transporteur' => $this->input->post('id_transporteur'),
				'qte' => $this->input->post('qte'),
				'qte_unite' => $this->input->post('qte_unite'),
				'cout' => $this->input->post('cout'),
			];

			
			
			$save_agritun_transport = $this->model_agritun_transport->store($save_data);
            

			if ($save_agritun_transport) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_agritun_transport;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/agritun_transport/edit/' . $save_agritun_transport, 'Edit Agritun Transport'),
						anchor('administrator/agritun_transport', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/agritun_transport/edit/' . $save_agritun_transport, 'Edit Agritun Transport')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_transport');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_transport');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Agritun Transports
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('agritun_transport_update');

		$this->data['agritun_transport'] = $this->model_agritun_transport->find($id);

		$this->template->title('عمليات التوصيل Update');
		$this->render('backend/standart/administrator/agritun_transport/agritun_transport_update', $this->data);
	}

	/**
	* Update Agritun Transports
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('agritun_transport_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('id_transporteur', 'السائق', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte', 'الكمية', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('qte_unite', 'وحدة القيس', 'trim|required');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'date' => date('Y-m-d H:i:s'),
				'id_transporteur' => $this->input->post('id_transporteur'),
				'qte' => $this->input->post('qte'),
				'qte_unite' => $this->input->post('qte_unite'),
				'cout' => $this->input->post('cout'),
			];


			
			
			$save_agritun_transport = $this->model_agritun_transport->change($id, $save_data);

			if ($save_agritun_transport) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/agritun_transport', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/agritun_transport');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/agritun_transport');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Agritun Transports
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('agritun_transport_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'agritun_transport'), 'success');
        } else {
            set_message(cclang('error_delete', 'agritun_transport'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Agritun Transports
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('agritun_transport_view');

		$this->data['agritun_transport'] = $this->model_agritun_transport->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('عمليات التوصيل Detail');
		$this->render('backend/standart/administrator/agritun_transport/agritun_transport_view', $this->data);
	}
	
	/**
	* delete Agritun Transports
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$agritun_transport = $this->model_agritun_transport->find($id);

		
		
		return $this->model_agritun_transport->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('agritun_transport_export');

		$this->model_agritun_transport->export(
			'agritun_transport', 
			'agritun_transport',
			$this->model_agritun_transport->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('agritun_transport_export');

		$this->model_agritun_transport->pdf('agritun_transport', 'agritun_transport');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('agritun_transport_export');

		$table = $title = 'agritun_transport';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_agritun_transport->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file agritun_transport.php */
/* Location: ./application/controllers/administrator/Agritun Transport.php */