<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Agritun_vente extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_agritun_vente');
	}

	/**
	 * @api {get} /agritun_vente/all Get all agritun_ventes.
	 * @apiVersion 0.1.0
	 * @apiName AllAgritunvente 
	 * @apiGroup agritun_vente
	 * @apiHeader {String} X-Api-Key Agritun ventes unique access-key.
	 * @apiHeader {String} X-Token Agritun ventes unique token.
	 * @apiPermission Agritun vente Cant be Accessed permission name : api_agritun_vente_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Agritun ventes.
	 * @apiParam {String} [Field="All Field"] Optional field of Agritun ventes : id, type_vente, qualite, quantite, prix_u, montant, acheteur, date, tel, i_src, user_id, id_parcel.
	 * @apiParam {String} [Start=0] Optional start index of Agritun ventes.
	 * @apiParam {String} [Limit=10] Optional limit data of Agritun ventes.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_vente.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataAgritun vente Agritun vente data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_agritun_vente_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'type_vente', 'qualite', 'quantite', 'prix_u', 'montant', 'acheteur', 'date', 'tel', 'i_src', 'user_id', 'id_parcel'];
		$agritun_ventes = $this->model_api_agritun_vente->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_agritun_vente->count_all($filter, $field);
		$agritun_ventes = array_map(function($row){
						
			return $row;
		}, $agritun_ventes);

		$data['agritun_vente'] = $agritun_ventes;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Agritun vente',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /agritun_vente/detail Detail Agritun vente.
	 * @apiVersion 0.1.0
	 * @apiName DetailAgritun vente
	 * @apiGroup agritun_vente
	 * @apiHeader {String} X-Api-Key Agritun ventes unique access-key.
	 * @apiHeader {String} X-Token Agritun ventes unique token.
	 * @apiPermission Agritun vente Cant be Accessed permission name : api_agritun_vente_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun ventes.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of agritun_vente.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Agritun venteNotFound Agritun vente data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_agritun_vente_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'type_vente', 'qualite', 'quantite', 'prix_u', 'montant', 'acheteur', 'date', 'tel', 'i_src', 'user_id', 'id_parcel'];
		$agritun_vente = $this->model_api_agritun_vente->find($id, $select_field);

		if (!$agritun_vente) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['agritun_vente'] = $agritun_vente;
		if ($data['agritun_vente']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Agritun vente',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun vente not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /agritun_vente/add Add Agritun vente.
	 * @apiVersion 0.1.0
	 * @apiName AddAgritun vente
	 * @apiGroup agritun_vente
	 * @apiHeader {String} X-Api-Key Agritun ventes unique access-key.
	 * @apiHeader {String} X-Token Agritun ventes unique token.
	 * @apiPermission Agritun vente Cant be Accessed permission name : api_agritun_vente_add
	 *
 	 * @apiParam {String} Type_vente Mandatory type_vente of Agritun ventes. Input Type Vente Max Length : 300. 
	 * @apiParam {String} Qualite Mandatory qualite of Agritun ventes. Input Qualite Max Length : 300. 
	 * @apiParam {String} Quantite Mandatory quantite of Agritun ventes. Input Quantite Max Length : 300. 
	 * @apiParam {String} Prix_u Mandatory prix_u of Agritun ventes. Input Prix U Max Length : 300. 
	 * @apiParam {String} Montant Mandatory montant of Agritun ventes. Input Montant Max Length : 300. 
	 * @apiParam {String} Acheteur Mandatory acheteur of Agritun ventes. Input Acheteur Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Agritun ventes. Input Tel Max Length : 11. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun ventes. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun ventes. Input User Id Max Length : 11. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun ventes. Input Id Parcel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_agritun_vente_add');

		$this->form_validation->set_rules('type_vente', 'Type Vente', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite', 'Qualite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('quantite', 'Quantite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('prix_u', 'Prix U', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('montant', 'Montant', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('acheteur', 'Acheteur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|max_length[300]|required');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'type_vente' => $this->input->post('type_vente'),
				'qualite' => $this->input->post('qualite'),
				'quantite' => $this->input->post('quantite'),
				'prix_u' => $this->input->post('prix_u'),
				'montant' => $this->input->post('montant'),
				'acheteur' => $this->input->post('acheteur'),
				'tel' => $this->input->post('tel'),
				'i_src' => $this->input->post('i_src'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_vente = $this->model_api_agritun_vente->store($save_data);

			if ($save_agritun_vente) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /agritun_vente/update Update Agritun vente.
	 * @apiVersion 0.1.0
	 * @apiName UpdateAgritun vente
	 * @apiGroup agritun_vente
	 * @apiHeader {String} X-Api-Key Agritun ventes unique access-key.
	 * @apiHeader {String} X-Token Agritun ventes unique token.
	 * @apiPermission Agritun vente Cant be Accessed permission name : api_agritun_vente_update
	 *
	 * @apiParam {String} Type_vente Mandatory type_vente of Agritun ventes. Input Type Vente Max Length : 300. 
	 * @apiParam {String} Qualite Mandatory qualite of Agritun ventes. Input Qualite Max Length : 300. 
	 * @apiParam {String} Quantite Mandatory quantite of Agritun ventes. Input Quantite Max Length : 300. 
	 * @apiParam {String} Prix_u Mandatory prix_u of Agritun ventes. Input Prix U Max Length : 300. 
	 * @apiParam {String} Montant Mandatory montant of Agritun ventes. Input Montant Max Length : 300. 
	 * @apiParam {String} Acheteur Mandatory acheteur of Agritun ventes. Input Acheteur Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Agritun ventes. Input Tel Max Length : 11. 
	 * @apiParam {String} I_src Mandatory i_src of Agritun ventes. Input I Src Max Length : 300. 
	 * @apiParam {String} User_id Mandatory user_id of Agritun ventes. Input User Id Max Length : 11. 
	 * @apiParam {String} [Id_parcel] Optional id_parcel of Agritun ventes. Input Id Parcel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Agritun Vente.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_agritun_vente_update');

		
		$this->form_validation->set_rules('type_vente', 'Type Vente', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('qualite', 'Qualite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('quantite', 'Quantite', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('prix_u', 'Prix U', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('montant', 'Montant', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('acheteur', 'Acheteur', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('i_src', 'I Src', 'trim|max_length[300]|required');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('id_parcel', 'Id Parcel', 'trim|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'type_vente' => $this->input->post('type_vente'),
				'qualite' => $this->input->post('qualite'),
				'quantite' => $this->input->post('quantite'),
				'prix_u' => $this->input->post('prix_u'),
				'montant' => $this->input->post('montant'),
				'acheteur' => $this->input->post('acheteur'),
				'tel' => $this->input->post('tel'),
				'i_src' => $this->input->post('i_src'),
				'user_id' => $this->input->post('user_id'),
				'id_parcel' => $this->input->post('id_parcel'),
			];
			
			$save_agritun_vente = $this->model_api_agritun_vente->change($this->post('id'), $save_data);

			if ($save_agritun_vente) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /agritun_vente/delete Delete Agritun vente. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteAgritun vente
	 * @apiGroup agritun_vente
	 * @apiHeader {String} X-Api-Key Agritun ventes unique access-key.
	 * @apiHeader {String} X-Token Agritun ventes unique token.
	 	 * @apiPermission Agritun vente Cant be Accessed permission name : api_agritun_vente_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Agritun ventes .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_agritun_vente_delete');

		$agritun_vente = $this->model_api_agritun_vente->find($this->post('id'));

		if (!$agritun_vente) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun vente not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_agritun_vente->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Agritun vente deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Agritun vente not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Agritun vente.php */
/* Location: ./application/controllers/api/Agritun vente.php */