<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Amina Controller
*| --------------------------------------------------------------------------
*| Amina site
*|
*/
class Amina extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_Amina');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Aminas
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('Amina_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['Aminas'] = $this->model_Amina->get($filter, $field, $this->limit_page, $offset);
		$this->data['Amina_counts'] = $this->model_Amina->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/Amina/index/',
			'total_rows'   => $this->data['Amina_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Amina List');
		$this->render('backend/standart/administrator/Amina/Amina_list', $this->data);
	}
	
	/**
	* Add new Aminas
	*
	*/
	public function add()
	{
		$this->is_allowed('Amina_add');

		$this->template->title('Amina New');
		$this->render('backend/standart/administrator/Amina/Amina_add', $this->data);
	}

	/**
	* Add New Aminas
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('Amina_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		

		$this->form_validation->set_rules('lat', 'Lat', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('lon', 'Lon', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('nbr_pieds', 'Nbr Pieds', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('mode_culture', 'Mode Culture', 'trim|required|max_length[200]');
		

		$this->form_validation->set_rules('nbr_hect', 'Nbr Hect', 'trim|required|max_length[11]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'lat' => $this->input->post('lat'),
				'lon' => $this->input->post('lon'),
				'nbr_pieds' => $this->input->post('nbr_pieds'),
				'mode_culture' => $this->input->post('mode_culture'),
				'nbr_hect' => $this->input->post('nbr_hect'),
			];

			
			
			$save_Amina = $this->model_Amina->store($save_data);
            

			if ($save_Amina) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_Amina;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/Amina/edit/' . $save_Amina, 'Edit Amina'),
						anchor('administrator/Amina', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/Amina/edit/' . $save_Amina, 'Edit Amina')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/Amina');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/Amina');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Aminas
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('Amina_update');

		$this->data['Amina'] = $this->model_Amina->find($id);

		$this->template->title('Amina Update');
		$this->render('backend/standart/administrator/Amina/Amina_update', $this->data);
	}

	/**
	* Update Aminas
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('Amina_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		

		$this->form_validation->set_rules('lat', 'Lat', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('lon', 'Lon', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('nbr_pieds', 'Nbr Pieds', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('mode_culture', 'Mode Culture', 'trim|required|max_length[200]');
		

		$this->form_validation->set_rules('nbr_hect', 'Nbr Hect', 'trim|required|max_length[11]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'lat' => $this->input->post('lat'),
				'lon' => $this->input->post('lon'),
				'nbr_pieds' => $this->input->post('nbr_pieds'),
				'mode_culture' => $this->input->post('mode_culture'),
				'nbr_hect' => $this->input->post('nbr_hect'),
			];


			
			
			$save_Amina = $this->model_Amina->change($id, $save_data);

			if ($save_Amina) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/Amina', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/Amina');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/Amina');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Aminas
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('Amina_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'Amina'), 'success');
        } else {
            set_message(cclang('error_delete', 'Amina'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Aminas
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('Amina_view');

		$this->data['Amina'] = $this->model_Amina->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Amina Detail');
		$this->render('backend/standart/administrator/Amina/Amina_view', $this->data);
	}
	
	/**
	* delete Aminas
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$Amina = $this->model_Amina->find($id);

		
		
		return $this->model_Amina->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('Amina_export');

		$this->model_Amina->export(
			'Amina', 
			'Amina',
			$this->model_Amina->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('Amina_export');

		$this->model_Amina->pdf('Amina', 'Amina');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('Amina_export');

		$table = $title = 'Amina';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_Amina->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file Amina.php */
/* Location: ./application/controllers/administrator/Amina.php */