<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Parcels extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_parcels');
	}

	/**
	 * @api {get} /parcels/all Get all parcelss.
	 * @apiVersion 0.1.0
	 * @apiName AllParcels 
	 * @apiGroup parcels
	 * @apiHeader {String} X-Api-Key Parcelss unique access-key.
	 * @apiHeader {String} X-Token Parcelss unique token.
	 * @apiPermission Parcels Cant be Accessed permission name : api_parcels_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Parcelss.
	 * @apiParam {String} [Field="All Field"] Optional field of Parcelss : id, name, region, gouvernorat, nbr_pieds, mode_culture, nbr_hect, mode_de_planteur, user_id.
	 * @apiParam {String} [Start=0] Optional start index of Parcelss.
	 * @apiParam {String} [Limit=10] Optional limit data of Parcelss.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of parcels.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataParcels Parcels data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_parcels_all');

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'name', 'region', 'gouvernorat', 'nbr_pieds', 'mode_culture', 'nbr_hect', 'mode_de_planteur', 'user_id'];
		$parcelss = $this->model_api_parcels->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_parcels->count_all($filter, $field);
		$parcelss = array_map(function($row){
			
			
			return $row;
		}, $parcelss);

		$data['parcels'] = $parcelss;
		
		
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Parcels',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

	
	/**
	 * @api {get} /parcels/detail Detail Parcels.
	 * @apiVersion 0.1.0
	 * @apiName DetailParcels
	 * @apiGroup parcels
	 * @apiHeader {String} X-Api-Key Parcelss unique access-key.
	 * @apiHeader {String} X-Token Parcelss unique token.
	 * @apiPermission Parcels Cant be Accessed permission name : api_parcels_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Parcelss.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of parcels.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ParcelsNotFound Parcels data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_parcels_detail');

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'name', 'region', 'gouvernorat', 'nbr_pieds', 'mode_culture', 'nbr_hect', 'mode_de_planteur', 'user_id'];
		$parcels = $this->model_api_parcels->find($id, $select_field);

		if (!$parcels) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

		
			
		$data['parcels'] = $parcels;
		if ($data['parcels']) {
			

			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Parcels',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Parcels not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /parcels/add Add Parcels.
	 * @apiVersion 0.1.0
	 * @apiName AddParcels
	 * @apiGroup parcels
	 * @apiHeader {String} X-Api-Key Parcelss unique access-key.
	 * @apiHeader {String} X-Token Parcelss unique token.
	 * @apiPermission Parcels Cant be Accessed permission name : api_parcels_add
	 *
 	 * @apiParam {String} Name Mandatory name of Parcelss. Input Name Max Length : 200. 
	 * @apiParam {String} Region Mandatory region of Parcelss. Input Region Max Length : 300. 
	 * @apiParam {String} Gouvernorat Mandatory gouvernorat of Parcelss. Input Gouvernorat Max Length : 300. 
	 * @apiParam {String} Nbr_pieds Mandatory nbr_pieds of Parcelss. Input Nbr Pieds Max Length : 11. 
	 * @apiParam {String} Mode_culture Mandatory mode_culture of Parcelss. Input Mode Culture Max Length : 200. 
	 * @apiParam {String} Nbr_hect Mandatory nbr_hect of Parcelss. Input Nbr Hect Max Length : 11. 
	 * @apiParam {String} Mode_de_planteur Mandatory mode_de_planteur of Parcelss. Input Mode De Planteur Max Length : 3000. 
	 * @apiParam {String} User_id Mandatory user_id of Parcelss. Input User Id Max Length : 11. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_parcels_add');

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('region', 'Region', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('gouvernorat', 'Gouvernorat', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('nbr_pieds', 'Nbr Pieds', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('mode_culture', 'Mode Culture', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('nbr_hect', 'Nbr Hect', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('mode_de_planteur', 'Mode De Planteur', 'trim|required|max_length[3000]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'name' => $this->input->post('name'),

			
	'region' => $this->input->post('region'),

			
	'gouvernorat' => $this->input->post('gouvernorat'),

			
	'nbr_pieds' => $this->input->post('nbr_pieds'),

			
	'mode_culture' => $this->input->post('mode_culture'),

			
	'nbr_hect' => $this->input->post('nbr_hect'),

			
	'mode_de_planteur' => $this->input->post('mode_de_planteur'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_parcels = $this->model_api_parcels->store($save_data);

			if ($save_parcels) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /parcels/update Update Parcels.
	 * @apiVersion 0.1.0
	 * @apiName UpdateParcels
	 * @apiGroup parcels
	 * @apiHeader {String} X-Api-Key Parcelss unique access-key.
	 * @apiHeader {String} X-Token Parcelss unique token.
	 * @apiPermission Parcels Cant be Accessed permission name : api_parcels_update
	 *
	 * @apiParam {String} Name Mandatory name of Parcelss. Input Name Max Length : 200. 
	 * @apiParam {String} Region Mandatory region of Parcelss. Input Region Max Length : 300. 
	 * @apiParam {String} Gouvernorat Mandatory gouvernorat of Parcelss. Input Gouvernorat Max Length : 300. 
	 * @apiParam {String} Nbr_pieds Mandatory nbr_pieds of Parcelss. Input Nbr Pieds Max Length : 11. 
	 * @apiParam {String} Mode_culture Mandatory mode_culture of Parcelss. Input Mode Culture Max Length : 200. 
	 * @apiParam {String} Nbr_hect Mandatory nbr_hect of Parcelss. Input Nbr Hect Max Length : 11. 
	 * @apiParam {String} Mode_de_planteur Mandatory mode_de_planteur of Parcelss. Input Mode De Planteur Max Length : 3000. 
	 * @apiParam {String} User_id Mandatory user_id of Parcelss. Input User Id Max Length : 11. 
	 * @apiParam {Integer} id Mandatory id of Parcels.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_parcels_update');

		
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('region', 'Region', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('gouvernorat', 'Gouvernorat', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('nbr_pieds', 'Nbr Pieds', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('mode_culture', 'Mode Culture', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('nbr_hect', 'Nbr Hect', 'trim|required|max_length[11]');
		$this->form_validation->set_rules('mode_de_planteur', 'Mode De Planteur', 'trim|required|max_length[3000]');
		$this->form_validation->set_rules('user_id', 'User Id', 'trim|required|max_length[11]');
		

		if ($this->form_validation->run()) {

			$save_data = [
			
	'name' => $this->input->post('name'),

			
	'region' => $this->input->post('region'),

			
	'gouvernorat' => $this->input->post('gouvernorat'),

			
	'nbr_pieds' => $this->input->post('nbr_pieds'),

			
	'mode_culture' => $this->input->post('mode_culture'),

			
	'nbr_hect' => $this->input->post('nbr_hect'),

			
	'mode_de_planteur' => $this->input->post('mode_de_planteur'),

			
	'user_id' => $this->input->post('user_id'),

			];
			

			$save_parcels = $this->model_api_parcels->change($this->post('id'), $save_data);

			if ($save_parcels) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /parcels/delete Delete Parcels. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteParcels
	 * @apiGroup parcels
	 * @apiHeader {String} X-Api-Key Parcelss unique access-key.
	 * @apiHeader {String} X-Token Parcelss unique token.
	 
	 * @apiPermission Parcels Cant be Accessed permission name : api_parcels_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Parcelss .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_parcels_delete');

		$parcels = $this->model_api_parcels->find($this->post('id'));

		if (!$parcels) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Parcels not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_parcels->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Parcels deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Parcels not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	

}

/* End of file Parcels.php */
/* Location: ./application/controllers/api/Parcels.php */