<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Parcels Controller
*| --------------------------------------------------------------------------
*| Parcels site
*|
*/
class Parcels extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_parcels');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Parcelss
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('parcels_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['parcelss'] = $this->model_parcels->get($filter, $field, $this->limit_page, $offset);
		$this->data['parcels_counts'] = $this->model_parcels->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/parcels/index/',
			'total_rows'   => $this->data['parcels_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Parcels List');
		$this->render('backend/standart/administrator/parcels/parcels_list', $this->data);
	}
	
	/**
	* Add new parcelss
	*
	*/
	public function add()
	{
		$this->is_allowed('parcels_add');

		$this->template->title('Parcels New');
		$this->render('backend/standart/administrator/parcels/parcels_add', $this->data);
	}

	/**
	* Add New Parcelss
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('parcels_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('name', 'الاسم', 'trim|required|max_length[200]');
		

		$this->form_validation->set_rules('region', 'الولاية', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('gouvernorat', 'المعتمدية', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('nbr_pieds', 'عدد الأشجار', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('nbr_hect', 'عدد الهكتارات', 'trim|max_length[11]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'region' => $this->input->post('region'),
				'gouvernorat' => $this->input->post('gouvernorat'),
				'nbr_pieds' => $this->input->post('nbr_pieds'),
				'mode_culture' => $this->input->post('mode_culture'),
				'nbr_hect' => $this->input->post('nbr_hect'),
				'mode_de_planteur' => $this->input->post('mode_de_planteur'),
			];

			
			
			$save_parcels = $this->model_parcels->store($save_data);
            

			if ($save_parcels) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_parcels;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/parcels/edit/' . $save_parcels, 'Edit Parcels'),
						anchor('administrator/parcels', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/parcels/edit/' . $save_parcels, 'Edit Parcels')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/parcels');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/parcels');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Parcelss
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('parcels_update');

		$this->data['parcels'] = $this->model_parcels->find($id);

		$this->template->title('Parcels Update');
		$this->render('backend/standart/administrator/parcels/parcels_update', $this->data);
	}

	/**
	* Update Parcelss
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('parcels_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('name', 'الاسم', 'trim|required|max_length[200]');
		

		$this->form_validation->set_rules('region', 'الولاية', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('gouvernorat', 'المعتمدية', 'trim|max_length[300]');
		

		$this->form_validation->set_rules('nbr_pieds', 'عدد الأشجار', 'trim|required|max_length[11]');
		

		$this->form_validation->set_rules('nbr_hect', 'عدد الهكتارات', 'trim|max_length[11]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'name' => $this->input->post('name'),
				'region' => $this->input->post('region'),
				'gouvernorat' => $this->input->post('gouvernorat'),
				'nbr_pieds' => $this->input->post('nbr_pieds'),
				'mode_culture' => $this->input->post('mode_culture'),
				'nbr_hect' => $this->input->post('nbr_hect'),
				'mode_de_planteur' => $this->input->post('mode_de_planteur'),
			];


			
			
			$save_parcels = $this->model_parcels->change($id, $save_data);

			if ($save_parcels) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/parcels', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/parcels');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/parcels');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Parcelss
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('parcels_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'parcels'), 'success');
        } else {
            set_message(cclang('error_delete', 'parcels'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Parcelss
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('parcels_view');

		$this->data['parcels'] = $this->model_parcels->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Parcels Detail');
		$this->render('backend/standart/administrator/parcels/parcels_view', $this->data);
	}
	
	/**
	* delete Parcelss
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$parcels = $this->model_parcels->find($id);

		
		
		return $this->model_parcels->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('parcels_export');

		$this->model_parcels->export(
			'parcels', 
			'parcels',
			$this->model_parcels->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('parcels_export');

		$this->model_parcels->pdf('parcels', 'parcels');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('parcels_export');

		$table = $title = 'parcels';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_parcels->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file parcels.php */
/* Location: ./application/controllers/administrator/Parcels.php */