<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Services extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_services');
	}

	/**
	 * @api {get} /services/all Get all servicess.
	 * @apiVersion 0.1.0
	 * @apiName AllServices 
	 * @apiGroup services
	 * @apiHeader {String} X-Api-Key Servicess unique access-key.
	 * @apiPermission Services Cant be Accessed permission name : api_services_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Servicess.
	 * @apiParam {String} [Field="All Field"] Optional field of Servicess : id, icon, name, description, color.
	 * @apiParam {String} [Start=0] Optional start index of Servicess.
	 * @apiParam {String} [Limit=10] Optional limit data of Servicess.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of services.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataServices Services data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_services_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'icon', 'name', 'description', 'color'];
		$servicess = $this->model_api_services->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_services->count_all($filter, $field);
		$servicess = array_map(function($row){
						
			return $row;
		}, $servicess);

		$data['services'] = $servicess;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Services',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /services/detail Detail Services.
	 * @apiVersion 0.1.0
	 * @apiName DetailServices
	 * @apiGroup services
	 * @apiHeader {String} X-Api-Key Servicess unique access-key.
	 * @apiPermission Services Cant be Accessed permission name : api_services_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Servicess.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of services.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ServicesNotFound Services data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_services_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'icon', 'name', 'description', 'color'];
		$services = $this->model_api_services->find($id, $select_field);

		if (!$services) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['services'] = $services;
		if ($data['services']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Services',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Services not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /services/add Add Services.
	 * @apiVersion 0.1.0
	 * @apiName AddServices
	 * @apiGroup services
	 * @apiHeader {String} X-Api-Key Servicess unique access-key.
	 * @apiPermission Services Cant be Accessed permission name : api_services_add
	 *
 	 * @apiParam {String} Icon Mandatory icon of Servicess. Input Icon Max Length : 100. 
	 * @apiParam {String} Name Mandatory name of Servicess. Input Name Max Length : 300. 
	 * @apiParam {String} Description Mandatory description of Servicess.  
	 * @apiParam {String} Color Mandatory color of Servicess. Input Color Max Length : 10. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_services_add', false);

		$this->form_validation->set_rules('icon', 'Icon', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		$this->form_validation->set_rules('color', 'Color', 'trim|required|max_length[10]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'icon' => $this->input->post('icon'),
				'name' => $this->input->post('name'),
				'description' => $this->input->post('description'),
				'color' => $this->input->post('color'),
			];
			
			$save_services = $this->model_api_services->store($save_data);

			if ($save_services) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /services/update Update Services.
	 * @apiVersion 0.1.0
	 * @apiName UpdateServices
	 * @apiGroup services
	 * @apiHeader {String} X-Api-Key Servicess unique access-key.
	 * @apiPermission Services Cant be Accessed permission name : api_services_update
	 *
	 * @apiParam {String} Icon Mandatory icon of Servicess. Input Icon Max Length : 100. 
	 * @apiParam {String} Name Mandatory name of Servicess. Input Name Max Length : 300. 
	 * @apiParam {String} Description Mandatory description of Servicess.  
	 * @apiParam {String} Color Mandatory color of Servicess. Input Color Max Length : 10. 
	 * @apiParam {Integer} id Mandatory id of Services.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_services_update', false);

		
		$this->form_validation->set_rules('icon', 'Icon', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		$this->form_validation->set_rules('color', 'Color', 'trim|required|max_length[10]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'icon' => $this->input->post('icon'),
				'name' => $this->input->post('name'),
				'description' => $this->input->post('description'),
				'color' => $this->input->post('color'),
			];
			
			$save_services = $this->model_api_services->change($this->post('id'), $save_data);

			if ($save_services) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /services/delete Delete Services. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteServices
	 * @apiGroup services
	 * @apiHeader {String} X-Api-Key Servicess unique access-key.
	 	 * @apiPermission Services Cant be Accessed permission name : api_services_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Servicess .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_services_delete', false);

		$services = $this->model_api_services->find($this->post('id'));

		if (!$services) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Services not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_services->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Services deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Services not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Services.php */
/* Location: ./application/controllers/api/Services.php */