<?php
defined('BASEPATH') OR exit('No direct script access allowed');


/**
*| --------------------------------------------------------------------------
*| Services Controller
*| --------------------------------------------------------------------------
*| Services site
*|
*/
class Services extends Admin	
{
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('model_services');
		$this->load->model('group/model_group');
		$this->lang->load('web_lang', $this->current_lang);
	}

	/**
	* show all Servicess
	*
	* @var $offset String
	*/
	public function index($offset = 0)
	{
		$this->is_allowed('services_list');

		$filter = $this->input->get('q');
		$field 	= $this->input->get('f');

		$this->data['servicess'] = $this->model_services->get($filter, $field, $this->limit_page, $offset);
		$this->data['services_counts'] = $this->model_services->count_all($filter, $field);

		$config = [
			'base_url'     => 'administrator/services/index/',
			'total_rows'   => $this->data['services_counts'],
			'per_page'     => $this->limit_page,
			'uri_segment'  => 4,
		];

		$this->data['pagination'] = $this->pagination($config);

		$this->template->title('Services List');
		$this->render('backend/standart/administrator/services/services_list', $this->data);
	}
	
	/**
	* Add new servicess
	*
	*/
	public function add()
	{
		$this->is_allowed('services_add');

		$this->template->title('Services New');
		$this->render('backend/standart/administrator/services/services_add', $this->data);
	}

	/**
	* Add New Servicess
	*
	* @return JSON
	*/
	public function add_save()
	{
		if (!$this->is_allowed('services_add', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
		
		

		$this->form_validation->set_rules('icon', 'Icon', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		

		$this->form_validation->set_rules('color', 'Color', 'trim|required|max_length[10]');
		

		

		if ($this->form_validation->run()) {
		
			$save_data = [
				'icon' => $this->input->post('icon'),
				'name' => $this->input->post('name'),
				'description' => $this->input->post('description'),
				'color' => $this->input->post('color'),
			];

			
			
			$save_services = $this->model_services->store($save_data);
            

			if ($save_services) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $save_services;
					$this->data['message'] = cclang('success_save_data_stay', [
						anchor('administrator/services/edit/' . $save_services, 'Edit Services'),
						anchor('administrator/services', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_save_data_redirect', [
						anchor('administrator/services/edit/' . $save_services, 'Edit Services')
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/services');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/services');
				}
			}

		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
		/**
	* Update view Servicess
	*
	* @var $id String
	*/
	public function edit($id)
	{
		$this->is_allowed('services_update');

		$this->data['services'] = $this->model_services->find($id);

		$this->template->title('Services Update');
		$this->render('backend/standart/administrator/services/services_update', $this->data);
	}

	/**
	* Update Servicess
	*
	* @var $id String
	*/
	public function edit_save($id)
	{
		if (!$this->is_allowed('services_update', false)) {
			echo json_encode([
				'success' => false,
				'message' => cclang('sorry_you_do_not_have_permission_to_access')
				]);
			exit;
		}
				$this->form_validation->set_rules('icon', 'Icon', 'trim|required|max_length[100]');
		

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		

		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		

		$this->form_validation->set_rules('color', 'Color', 'trim|required|max_length[10]');
		

		
		if ($this->form_validation->run()) {
		
			$save_data = [
				'icon' => $this->input->post('icon'),
				'name' => $this->input->post('name'),
				'description' => $this->input->post('description'),
				'color' => $this->input->post('color'),
			];


			
			
			$save_services = $this->model_services->change($id, $save_data);

			if ($save_services) {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = true;
					$this->data['id'] 	   = $id;
					$this->data['message'] = cclang('success_update_data_stay', [
						anchor('administrator/services', ' Go back to list')
					]);
				} else {
					set_message(
						cclang('success_update_data_redirect', [
					]), 'success');

            		$this->data['success'] = true;
					$this->data['redirect'] = base_url('administrator/services');
				}
			} else {
				if ($this->input->post('save_type') == 'stay') {
					$this->data['success'] = false;
					$this->data['message'] = cclang('data_not_change');
				} else {
            		$this->data['success'] = false;
            		$this->data['message'] = cclang('data_not_change');
					$this->data['redirect'] = base_url('administrator/services');
				}
			}
		} else {
			$this->data['success'] = false;
			$this->data['message'] = 'Opss validation failed';
			$this->data['errors'] = $this->form_validation->error_array();
		}

		$this->response($this->data);
	}
	
	/**
	* delete Servicess
	*
	* @var $id String
	*/
	public function delete($id = null)
	{
		$this->is_allowed('services_delete');

		$this->load->helper('file');

		$arr_id = $this->input->get('id');
		$remove = false;

		if (!empty($id)) {
			$remove = $this->_remove($id);
		} elseif (count($arr_id) >0) {
			foreach ($arr_id as $id) {
				$remove = $this->_remove($id);
			}
		}

		if ($remove) {
            set_message(cclang('has_been_deleted', 'services'), 'success');
        } else {
            set_message(cclang('error_delete', 'services'), 'error');
        }

		redirect_back();
	}

		/**
	* View view Servicess
	*
	* @var $id String
	*/
	public function view($id)
	{
		$this->is_allowed('services_view');

		$this->data['services'] = $this->model_services->join_avaiable()->filter_avaiable()->find($id);

		$this->template->title('Services Detail');
		$this->render('backend/standart/administrator/services/services_view', $this->data);
	}
	
	/**
	* delete Servicess
	*
	* @var $id String
	*/
	private function _remove($id)
	{
		$services = $this->model_services->find($id);

		
		
		return $this->model_services->remove($id);
	}
	
	
	/**
	* Export to excel
	*
	* @return Files Excel .xls
	*/
	public function export()
	{
		$this->is_allowed('services_export');

		$this->model_services->export(
			'services', 
			'services',
			$this->model_services->field_search
		);
	}

	/**
	* Export to PDF
	*
	* @return Files PDF .pdf
	*/
	public function export_pdf()
	{
		$this->is_allowed('services_export');

		$this->model_services->pdf('services', 'services');
	}


	public function single_pdf($id = null)
	{
		$this->is_allowed('services_export');

		$table = $title = 'services';
		$this->load->library('HtmlPdf');
      
        $config = array(
            'orientation' => 'p',
            'format' => 'a4',
            'marges' => array(5, 5, 5, 5)
        );

        $this->pdf = new HtmlPdf($config);
        $this->pdf->setDefaultFont('stsongstdlight'); 

        $result = $this->db->get($table);
       
        $data = $this->model_services->find($id);
        $fields = $result->list_fields();

        $content = $this->pdf->loadHtmlPdf('core_template/pdf/pdf_single', [
            'data' => $data,
            'fields' => $fields,
            'title' => $title
        ], TRUE);

        $this->pdf->initialize($config);
        $this->pdf->pdf->SetDisplayMode('fullpage');
        $this->pdf->writeHTML($content);
        $this->pdf->Output($table.'.pdf', 'H');
	}

	
}


/* End of file services.php */
/* Location: ./application/controllers/administrator/Services.php */