<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Tfarhida_stades extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_tfarhida_stades');
	}

	/**
	 * @api {get} /tfarhida_stades/all Get all tfarhida_stadess.
	 * @apiVersion 0.1.0
	 * @apiName AllTfarhidastades 
	 * @apiGroup tfarhida_stades
	 * @apiHeader {String} X-Api-Key Tfarhida stadess unique access-key.
	 * @apiPermission Tfarhida stades Cant be Accessed permission name : api_tfarhida_stades_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Tfarhida stadess.
	 * @apiParam {String} [Field="All Field"] Optional field of Tfarhida stadess : id, name, taille, localisation, tel.
	 * @apiParam {String} [Start=0] Optional start index of Tfarhida stadess.
	 * @apiParam {String} [Limit=10] Optional limit data of Tfarhida stadess.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of tfarhida_stades.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataTfarhida stades Tfarhida stades data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_tfarhida_stades_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'name', 'taille', 'localisation', 'tel'];
		$tfarhida_stadess = $this->model_api_tfarhida_stades->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_tfarhida_stades->count_all($filter, $field);
		$tfarhida_stadess = array_map(function($row){
						
			return $row;
		}, $tfarhida_stadess);

		$data['tfarhida_stades'] = $tfarhida_stadess;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Tfarhida stades',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /tfarhida_stades/detail Detail Tfarhida stades.
	 * @apiVersion 0.1.0
	 * @apiName DetailTfarhida stades
	 * @apiGroup tfarhida_stades
	 * @apiHeader {String} X-Api-Key Tfarhida stadess unique access-key.
	 * @apiPermission Tfarhida stades Cant be Accessed permission name : api_tfarhida_stades_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Tfarhida stadess.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of tfarhida_stades.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Tfarhida stadesNotFound Tfarhida stades data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_tfarhida_stades_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'name', 'taille', 'localisation', 'tel'];
		$tfarhida_stades = $this->model_api_tfarhida_stades->find($id, $select_field);

		if (!$tfarhida_stades) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['tfarhida_stades'] = $tfarhida_stades;
		if ($data['tfarhida_stades']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Tfarhida stades',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Tfarhida stades not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /tfarhida_stades/add Add Tfarhida stades.
	 * @apiVersion 0.1.0
	 * @apiName AddTfarhida stades
	 * @apiGroup tfarhida_stades
	 * @apiHeader {String} X-Api-Key Tfarhida stadess unique access-key.
	 * @apiPermission Tfarhida stades Cant be Accessed permission name : api_tfarhida_stades_add
	 *
 	 * @apiParam {String} Name Mandatory name of Tfarhida stadess. Input Name Max Length : 300. 
	 * @apiParam {String} Taille Mandatory taille of Tfarhida stadess. Input Taille Max Length : 300. 
	 * @apiParam {String} Localisation Mandatory localisation of Tfarhida stadess. Input Localisation Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Tfarhida stadess. Input Tel Max Length : 300. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_tfarhida_stades_add', false);

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('taille', 'Taille', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('localisation', 'Localisation', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
				'taille' => $this->input->post('taille'),
				'localisation' => $this->input->post('localisation'),
				'tel' => $this->input->post('tel'),
			];
			
			$save_tfarhida_stades = $this->model_api_tfarhida_stades->store($save_data);

			if ($save_tfarhida_stades) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /tfarhida_stades/update Update Tfarhida stades.
	 * @apiVersion 0.1.0
	 * @apiName UpdateTfarhida stades
	 * @apiGroup tfarhida_stades
	 * @apiHeader {String} X-Api-Key Tfarhida stadess unique access-key.
	 * @apiPermission Tfarhida stades Cant be Accessed permission name : api_tfarhida_stades_update
	 *
	 * @apiParam {String} Name Mandatory name of Tfarhida stadess. Input Name Max Length : 300. 
	 * @apiParam {String} Taille Mandatory taille of Tfarhida stadess. Input Taille Max Length : 300. 
	 * @apiParam {String} Localisation Mandatory localisation of Tfarhida stadess. Input Localisation Max Length : 300. 
	 * @apiParam {String} Tel Mandatory tel of Tfarhida stadess. Input Tel Max Length : 300. 
	 * @apiParam {Integer} id Mandatory id of Tfarhida Stades.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_tfarhida_stades_update', false);

		
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('taille', 'Taille', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('localisation', 'Localisation', 'trim|required|max_length[300]');
		$this->form_validation->set_rules('tel', 'Tel', 'trim|required|max_length[300]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
				'taille' => $this->input->post('taille'),
				'localisation' => $this->input->post('localisation'),
				'tel' => $this->input->post('tel'),
			];
			
			$save_tfarhida_stades = $this->model_api_tfarhida_stades->change($this->post('id'), $save_data);

			if ($save_tfarhida_stades) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /tfarhida_stades/delete Delete Tfarhida stades. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteTfarhida stades
	 * @apiGroup tfarhida_stades
	 * @apiHeader {String} X-Api-Key Tfarhida stadess unique access-key.
	 	 * @apiPermission Tfarhida stades Cant be Accessed permission name : api_tfarhida_stades_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Tfarhida stadess .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_tfarhida_stades_delete', false);

		$tfarhida_stades = $this->model_api_tfarhida_stades->find($this->post('id'));

		if (!$tfarhida_stades) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Tfarhida stades not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_tfarhida_stades->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Tfarhida stades deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Tfarhida stades not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Tfarhida stades.php */
/* Location: ./application/controllers/api/Tfarhida stades.php */