<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_apropos extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_apropos');
	}

	/**
	 * @api {get} /webvue_apropos/all Get all webvue_aproposs.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvueapropos 
	 * @apiGroup webvue_apropos
	 * @apiHeader {String} X-Api-Key Webvue aproposs unique access-key.
	 * @apiPermission Webvue apropos Cant be Accessed permission name : api_webvue_apropos_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue aproposs.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue aproposs : id, title, description, img_url.
	 * @apiParam {String} [Start=0] Optional start index of Webvue aproposs.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue aproposs.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_apropos.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue apropos Webvue apropos data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_apropos_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'title', 'description', 'img_url'];
		$webvue_aproposs = $this->model_api_webvue_apropos->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_apropos->count_all($filter, $field);
		$webvue_aproposs = array_map(function($row){
						
			return $row;
		}, $webvue_aproposs);

		$data['webvue_apropos'] = $webvue_aproposs;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue apropos',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_apropos/detail Detail Webvue apropos.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue apropos
	 * @apiGroup webvue_apropos
	 * @apiHeader {String} X-Api-Key Webvue aproposs unique access-key.
	 * @apiPermission Webvue apropos Cant be Accessed permission name : api_webvue_apropos_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue aproposs.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_apropos.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue aproposNotFound Webvue apropos data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_apropos_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'title', 'description', 'img_url'];
		$webvue_apropos = $this->model_api_webvue_apropos->find($id, $select_field);

		if (!$webvue_apropos) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_apropos'] = $webvue_apropos;
		if ($data['webvue_apropos']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue apropos',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue apropos not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_apropos/add Add Webvue apropos.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue apropos
	 * @apiGroup webvue_apropos
	 * @apiHeader {String} X-Api-Key Webvue aproposs unique access-key.
	 * @apiPermission Webvue apropos Cant be Accessed permission name : api_webvue_apropos_add
	 *
 	 * @apiParam {String} Title Mandatory title of Webvue aproposs. Input Title Max Length : 200. 
	 * @apiParam {String} Description Mandatory description of Webvue aproposs.  
	 * @apiParam {String} Img_url Mandatory img_url of Webvue aproposs.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_apropos_add', false);

		$this->form_validation->set_rules('title', 'Title', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'title' => $this->input->post('title'),
				'description' => $this->input->post('description'),
				'img_url' => $this->input->post('img_url'),
			];
			
			$save_webvue_apropos = $this->model_api_webvue_apropos->store($save_data);

			if ($save_webvue_apropos) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_apropos/update Update Webvue apropos.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue apropos
	 * @apiGroup webvue_apropos
	 * @apiHeader {String} X-Api-Key Webvue aproposs unique access-key.
	 * @apiPermission Webvue apropos Cant be Accessed permission name : api_webvue_apropos_update
	 *
	 * @apiParam {String} Title Mandatory title of Webvue aproposs. Input Title Max Length : 200. 
	 * @apiParam {String} Description Mandatory description of Webvue aproposs.  
	 * @apiParam {String} Img_url Mandatory img_url of Webvue aproposs.  
	 * @apiParam {Integer} id Mandatory id of Webvue Apropos.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_apropos_update', false);

		
		$this->form_validation->set_rules('title', 'Title', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'title' => $this->input->post('title'),
				'description' => $this->input->post('description'),
				'img_url' => $this->input->post('img_url'),
			];
			
			$save_webvue_apropos = $this->model_api_webvue_apropos->change($this->post('id'), $save_data);

			if ($save_webvue_apropos) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_apropos/delete Delete Webvue apropos. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue apropos
	 * @apiGroup webvue_apropos
	 * @apiHeader {String} X-Api-Key Webvue aproposs unique access-key.
	 	 * @apiPermission Webvue apropos Cant be Accessed permission name : api_webvue_apropos_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue aproposs .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_apropos_delete', false);

		$webvue_apropos = $this->model_api_webvue_apropos->find($this->post('id'));

		if (!$webvue_apropos) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue apropos not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_apropos->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue apropos deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue apropos not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue apropos.php */
/* Location: ./application/controllers/api/Webvue apropos.php */