<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_partenaires extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_partenaires');
	}

	/**
	 * @api {get} /webvue_partenaires/all Get all webvue_partenairess.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvuepartenaires 
	 * @apiGroup webvue_partenaires
	 * @apiHeader {String} X-Api-Key Webvue partenairess unique access-key.
	 * @apiPermission Webvue partenaires Cant be Accessed permission name : api_webvue_partenaires_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue partenairess.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue partenairess : id, image, name, link.
	 * @apiParam {String} [Start=0] Optional start index of Webvue partenairess.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue partenairess.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_partenaires.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue partenaires Webvue partenaires data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_partenaires_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'image', 'name', 'link'];
		$webvue_partenairess = $this->model_api_webvue_partenaires->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_partenaires->count_all($filter, $field);
		$webvue_partenairess = array_map(function($row){
						
			return $row;
		}, $webvue_partenairess);

		$data['webvue_partenaires'] = $webvue_partenairess;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue partenaires',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_partenaires/detail Detail Webvue partenaires.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue partenaires
	 * @apiGroup webvue_partenaires
	 * @apiHeader {String} X-Api-Key Webvue partenairess unique access-key.
	 * @apiPermission Webvue partenaires Cant be Accessed permission name : api_webvue_partenaires_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue partenairess.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_partenaires.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue partenairesNotFound Webvue partenaires data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_partenaires_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'image', 'name', 'link'];
		$webvue_partenaires = $this->model_api_webvue_partenaires->find($id, $select_field);

		if (!$webvue_partenaires) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_partenaires'] = $webvue_partenaires;
		if ($data['webvue_partenaires']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue partenaires',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue partenaires not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_partenaires/add Add Webvue partenaires.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue partenaires
	 * @apiGroup webvue_partenaires
	 * @apiHeader {String} X-Api-Key Webvue partenairess unique access-key.
	 * @apiPermission Webvue partenaires Cant be Accessed permission name : api_webvue_partenaires_add
	 *
 	 * @apiParam {String} Image Mandatory image of Webvue partenairess.  
	 * @apiParam {String} Name Mandatory name of Webvue partenairess. Input Name Max Length : 200. 
	 * @apiParam {String} Link Mandatory link of Webvue partenairess.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_partenaires_add', false);

		$this->form_validation->set_rules('image', 'Image', 'trim|required');
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'image' => $this->input->post('image'),
				'name' => $this->input->post('name'),
				'link' => $this->input->post('link'),
			];
			
			$save_webvue_partenaires = $this->model_api_webvue_partenaires->store($save_data);

			if ($save_webvue_partenaires) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_partenaires/update Update Webvue partenaires.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue partenaires
	 * @apiGroup webvue_partenaires
	 * @apiHeader {String} X-Api-Key Webvue partenairess unique access-key.
	 * @apiPermission Webvue partenaires Cant be Accessed permission name : api_webvue_partenaires_update
	 *
	 * @apiParam {String} Image Mandatory image of Webvue partenairess.  
	 * @apiParam {String} Name Mandatory name of Webvue partenairess. Input Name Max Length : 200. 
	 * @apiParam {String} Link Mandatory link of Webvue partenairess.  
	 * @apiParam {Integer} id Mandatory id of Webvue Partenaires.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_partenaires_update', false);

		
		$this->form_validation->set_rules('image', 'Image', 'trim|required');
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'image' => $this->input->post('image'),
				'name' => $this->input->post('name'),
				'link' => $this->input->post('link'),
			];
			
			$save_webvue_partenaires = $this->model_api_webvue_partenaires->change($this->post('id'), $save_data);

			if ($save_webvue_partenaires) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_partenaires/delete Delete Webvue partenaires. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue partenaires
	 * @apiGroup webvue_partenaires
	 * @apiHeader {String} X-Api-Key Webvue partenairess unique access-key.
	 	 * @apiPermission Webvue partenaires Cant be Accessed permission name : api_webvue_partenaires_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue partenairess .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_partenaires_delete', false);

		$webvue_partenaires = $this->model_api_webvue_partenaires->find($this->post('id'));

		if (!$webvue_partenaires) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue partenaires not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_partenaires->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue partenaires deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue partenaires not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue partenaires.php */
/* Location: ./application/controllers/api/Webvue partenaires.php */