<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_strategies extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_strategies');
	}

	/**
	 * @api {get} /webvue_strategies/all Get all webvue_strategiess.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvuestrategies 
	 * @apiGroup webvue_strategies
	 * @apiHeader {String} X-Api-Key Webvue strategiess unique access-key.
	 * @apiPermission Webvue strategies Cant be Accessed permission name : api_webvue_strategies_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue strategiess.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue strategiess : id, img_url.
	 * @apiParam {String} [Start=0] Optional start index of Webvue strategiess.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue strategiess.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_strategies.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue strategies Webvue strategies data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_strategies_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'img_url'];
		$webvue_strategiess = $this->model_api_webvue_strategies->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_strategies->count_all($filter, $field);
		$webvue_strategiess = array_map(function($row){
						
			return $row;
		}, $webvue_strategiess);

		$data['webvue_strategies'] = $webvue_strategiess;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue strategies',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_strategies/detail Detail Webvue strategies.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue strategies
	 * @apiGroup webvue_strategies
	 * @apiHeader {String} X-Api-Key Webvue strategiess unique access-key.
	 * @apiPermission Webvue strategies Cant be Accessed permission name : api_webvue_strategies_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue strategiess.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_strategies.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue strategiesNotFound Webvue strategies data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_strategies_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'img_url'];
		$webvue_strategies = $this->model_api_webvue_strategies->find($id, $select_field);

		if (!$webvue_strategies) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_strategies'] = $webvue_strategies;
		if ($data['webvue_strategies']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue strategies',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue strategies not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_strategies/add Add Webvue strategies.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue strategies
	 * @apiGroup webvue_strategies
	 * @apiHeader {String} X-Api-Key Webvue strategiess unique access-key.
	 * @apiPermission Webvue strategies Cant be Accessed permission name : api_webvue_strategies_add
	 *
 	 * @apiParam {String} Img_url Mandatory img_url of Webvue strategiess.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_strategies_add', false);

		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'img_url' => $this->input->post('img_url'),
			];
			
			$save_webvue_strategies = $this->model_api_webvue_strategies->store($save_data);

			if ($save_webvue_strategies) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_strategies/update Update Webvue strategies.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue strategies
	 * @apiGroup webvue_strategies
	 * @apiHeader {String} X-Api-Key Webvue strategiess unique access-key.
	 * @apiPermission Webvue strategies Cant be Accessed permission name : api_webvue_strategies_update
	 *
	 * @apiParam {String} Img_url Mandatory img_url of Webvue strategiess.  
	 * @apiParam {Integer} id Mandatory id of Webvue Strategies.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_strategies_update', false);

		
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'img_url' => $this->input->post('img_url'),
			];
			
			$save_webvue_strategies = $this->model_api_webvue_strategies->change($this->post('id'), $save_data);

			if ($save_webvue_strategies) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_strategies/delete Delete Webvue strategies. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue strategies
	 * @apiGroup webvue_strategies
	 * @apiHeader {String} X-Api-Key Webvue strategiess unique access-key.
	 	 * @apiPermission Webvue strategies Cant be Accessed permission name : api_webvue_strategies_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue strategiess .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_strategies_delete', false);

		$webvue_strategies = $this->model_api_webvue_strategies->find($this->post('id'));

		if (!$webvue_strategies) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue strategies not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_strategies->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue strategies deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue strategies not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue strategies.php */
/* Location: ./application/controllers/api/Webvue strategies.php */