<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_strategies_details extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_strategies_details');
	}

	/**
	 * @api {get} /webvue_strategies_details/all Get all webvue_strategies_detailss.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvuestrategiesdetails 
	 * @apiGroup webvue_strategies_details
	 * @apiHeader {String} X-Api-Key Webvue strategies detailss unique access-key.
	 * @apiPermission Webvue strategies details Cant be Accessed permission name : api_webvue_strategies_details_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue strategies detailss.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue strategies detailss : id, name.
	 * @apiParam {String} [Start=0] Optional start index of Webvue strategies detailss.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue strategies detailss.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_strategies_details.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue strategies details Webvue strategies details data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_strategies_details_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'name'];
		$webvue_strategies_detailss = $this->model_api_webvue_strategies_details->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_strategies_details->count_all($filter, $field);
		$webvue_strategies_detailss = array_map(function($row){
						
			return $row;
		}, $webvue_strategies_detailss);

		$data['webvue_strategies_details'] = $webvue_strategies_detailss;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue strategies details',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_strategies_details/detail Detail Webvue strategies details.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue strategies details
	 * @apiGroup webvue_strategies_details
	 * @apiHeader {String} X-Api-Key Webvue strategies detailss unique access-key.
	 * @apiPermission Webvue strategies details Cant be Accessed permission name : api_webvue_strategies_details_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue strategies detailss.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_strategies_details.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue strategies detailsNotFound Webvue strategies details data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_strategies_details_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'name'];
		$webvue_strategies_details = $this->model_api_webvue_strategies_details->find($id, $select_field);

		if (!$webvue_strategies_details) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_strategies_details'] = $webvue_strategies_details;
		if ($data['webvue_strategies_details']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue strategies details',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue strategies details not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_strategies_details/add Add Webvue strategies details.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue strategies details
	 * @apiGroup webvue_strategies_details
	 * @apiHeader {String} X-Api-Key Webvue strategies detailss unique access-key.
	 * @apiPermission Webvue strategies details Cant be Accessed permission name : api_webvue_strategies_details_add
	 *
 	 * @apiParam {String} Name Mandatory name of Webvue strategies detailss. Input Name Max Length : 400. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_strategies_details_add', false);

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[400]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
			];
			
			$save_webvue_strategies_details = $this->model_api_webvue_strategies_details->store($save_data);

			if ($save_webvue_strategies_details) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_strategies_details/update Update Webvue strategies details.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue strategies details
	 * @apiGroup webvue_strategies_details
	 * @apiHeader {String} X-Api-Key Webvue strategies detailss unique access-key.
	 * @apiPermission Webvue strategies details Cant be Accessed permission name : api_webvue_strategies_details_update
	 *
	 * @apiParam {String} Name Mandatory name of Webvue strategies detailss. Input Name Max Length : 400. 
	 * @apiParam {Integer} id Mandatory id of Webvue Strategies Details.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_strategies_details_update', false);

		
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[400]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
			];
			
			$save_webvue_strategies_details = $this->model_api_webvue_strategies_details->change($this->post('id'), $save_data);

			if ($save_webvue_strategies_details) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_strategies_details/delete Delete Webvue strategies details. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue strategies details
	 * @apiGroup webvue_strategies_details
	 * @apiHeader {String} X-Api-Key Webvue strategies detailss unique access-key.
	 	 * @apiPermission Webvue strategies details Cant be Accessed permission name : api_webvue_strategies_details_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue strategies detailss .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_strategies_details_delete', false);

		$webvue_strategies_details = $this->model_api_webvue_strategies_details->find($this->post('id'));

		if (!$webvue_strategies_details) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue strategies details not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_strategies_details->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue strategies details deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue strategies details not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue strategies details.php */
/* Location: ./application/controllers/api/Webvue strategies details.php */