<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_team extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_team');
	}

	/**
	 * @api {get} /webvue_team/all Get all webvue_teams.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvueteam 
	 * @apiGroup webvue_team
	 * @apiHeader {String} X-Api-Key Webvue teams unique access-key.
	 * @apiPermission Webvue team Cant be Accessed permission name : api_webvue_team_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue teams.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue teams : id, name, img_url, role, description.
	 * @apiParam {String} [Start=0] Optional start index of Webvue teams.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue teams.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_team.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue team Webvue team data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_team_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'name', 'img_url', 'role', 'description'];
		$webvue_teams = $this->model_api_webvue_team->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_team->count_all($filter, $field);
		$webvue_teams = array_map(function($row){
						
			return $row;
		}, $webvue_teams);

		$data['webvue_team'] = $webvue_teams;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue team',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_team/detail Detail Webvue team.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue team
	 * @apiGroup webvue_team
	 * @apiHeader {String} X-Api-Key Webvue teams unique access-key.
	 * @apiPermission Webvue team Cant be Accessed permission name : api_webvue_team_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue teams.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_team.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue teamNotFound Webvue team data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_team_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'name', 'img_url', 'role', 'description'];
		$webvue_team = $this->model_api_webvue_team->find($id, $select_field);

		if (!$webvue_team) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_team'] = $webvue_team;
		if ($data['webvue_team']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue team',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue team not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_team/add Add Webvue team.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue team
	 * @apiGroup webvue_team
	 * @apiHeader {String} X-Api-Key Webvue teams unique access-key.
	 * @apiPermission Webvue team Cant be Accessed permission name : api_webvue_team_add
	 *
 	 * @apiParam {String} Name Mandatory name of Webvue teams. Input Name Max Length : 200. 
	 * @apiParam {String} Img_url Mandatory img_url of Webvue teams.  
	 * @apiParam {String} Role Mandatory role of Webvue teams. Input Role Max Length : 200. 
	 * @apiParam {String} Description Mandatory description of Webvue teams.  
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_team_add', false);

		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		$this->form_validation->set_rules('role', 'Role', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
				'img_url' => $this->input->post('img_url'),
				'role' => $this->input->post('role'),
				'description' => $this->input->post('description'),
			];
			
			$save_webvue_team = $this->model_api_webvue_team->store($save_data);

			if ($save_webvue_team) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_team/update Update Webvue team.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue team
	 * @apiGroup webvue_team
	 * @apiHeader {String} X-Api-Key Webvue teams unique access-key.
	 * @apiPermission Webvue team Cant be Accessed permission name : api_webvue_team_update
	 *
	 * @apiParam {String} Name Mandatory name of Webvue teams. Input Name Max Length : 200. 
	 * @apiParam {String} Img_url Mandatory img_url of Webvue teams.  
	 * @apiParam {String} Role Mandatory role of Webvue teams. Input Role Max Length : 200. 
	 * @apiParam {String} Description Mandatory description of Webvue teams.  
	 * @apiParam {Integer} id Mandatory id of Webvue Team.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_team_update', false);

		
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('img_url', 'Img Url', 'trim|required');
		$this->form_validation->set_rules('role', 'Role', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('description', 'Description', 'trim|required');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'name' => $this->input->post('name'),
				'img_url' => $this->input->post('img_url'),
				'role' => $this->input->post('role'),
				'description' => $this->input->post('description'),
			];
			
			$save_webvue_team = $this->model_api_webvue_team->change($this->post('id'), $save_data);

			if ($save_webvue_team) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_team/delete Delete Webvue team. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue team
	 * @apiGroup webvue_team
	 * @apiHeader {String} X-Api-Key Webvue teams unique access-key.
	 	 * @apiPermission Webvue team Cant be Accessed permission name : api_webvue_team_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue teams .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_team_delete', false);

		$webvue_team = $this->model_api_webvue_team->find($this->post('id'));

		if (!$webvue_team) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue team not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_team->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue team deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue team not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue team.php */
/* Location: ./application/controllers/api/Webvue team.php */