<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class Webvue_team_media extends API
{
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('model_api_webvue_team_media');
	}

	/**
	 * @api {get} /webvue_team_media/all Get all webvue_team_medias.
	 * @apiVersion 0.1.0
	 * @apiName AllWebvueteammedia 
	 * @apiGroup webvue_team_media
	 * @apiHeader {String} X-Api-Key Webvue team medias unique access-key.
	 * @apiPermission Webvue team media Cant be Accessed permission name : api_webvue_team_media_all
	 *
	 * @apiParam {String} [Filter=null] Optional filter of Webvue team medias.
	 * @apiParam {String} [Field="All Field"] Optional field of Webvue team medias : id, member_id, name, link, icon.
	 * @apiParam {String} [Start=0] Optional start index of Webvue team medias.
	 * @apiParam {String} [Limit=10] Optional limit data of Webvue team medias.
	 *
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_team_media.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError NoDataWebvue team media Webvue team media data is nothing.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function all_get()
	{
		$this->is_allowed('api_webvue_team_media_all', false);

		$filter = $this->get('filter');
		$field = $this->get('field');
		$limit = $this->get('limit') ? $this->get('limit') : $this->limit_page;
		$start = $this->get('start');

		$select_field = ['id', 'member_id', 'name', 'link', 'icon'];
		$webvue_team_medias = $this->model_api_webvue_team_media->get($filter, $field, $limit, $start, $select_field);
		$total = $this->model_api_webvue_team_media->count_all($filter, $field);
		$webvue_team_medias = array_map(function($row){
						
			return $row;
		}, $webvue_team_medias);

		$data['webvue_team_media'] = $webvue_team_medias;
				
		$this->response([
			'status' 	=> true,
			'message' 	=> 'Data Webvue team media',
			'data'	 	=> $data,
			'total' 	=> $total,
		], API::HTTP_OK);
	}

		/**
	 * @api {get} /webvue_team_media/detail Detail Webvue team media.
	 * @apiVersion 0.1.0
	 * @apiName DetailWebvue team media
	 * @apiGroup webvue_team_media
	 * @apiHeader {String} X-Api-Key Webvue team medias unique access-key.
	 * @apiPermission Webvue team media Cant be Accessed permission name : api_webvue_team_media_detail
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue team medias.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 * @apiSuccess {Array} Data data of webvue_team_media.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError Webvue team mediaNotFound Webvue team media data is not found.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function detail_get()
	{
		$this->is_allowed('api_webvue_team_media_detail', false);

		$this->requiredInput(['id']);

		$id = $this->get('id');

		$select_field = ['id', 'member_id', 'name', 'link', 'icon'];
		$webvue_team_media = $this->model_api_webvue_team_media->find($id, $select_field);

		if (!$webvue_team_media) {
			$this->response([
					'status' 	=> false,
					'message' 	=> 'Blog not found'
				], API::HTTP_NOT_FOUND);
		}

					
		$data['webvue_team_media'] = $webvue_team_media;
		if ($data['webvue_team_media']) {
			
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Detail Webvue team media',
				'data'	 	=> $data
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue team media not found'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	
	/**
	 * @api {post} /webvue_team_media/add Add Webvue team media.
	 * @apiVersion 0.1.0
	 * @apiName AddWebvue team media
	 * @apiGroup webvue_team_media
	 * @apiHeader {String} X-Api-Key Webvue team medias unique access-key.
	 * @apiPermission Webvue team media Cant be Accessed permission name : api_webvue_team_media_add
	 *
 	 * @apiParam {String} Member_id Mandatory member_id of Webvue team medias. Input Member Id Max Length : 100. 
	 * @apiParam {String} Name Mandatory name of Webvue team medias. Input Name Max Length : 200. 
	 * @apiParam {String} Link Mandatory link of Webvue team medias.  
	 * @apiParam {String} Icon Mandatory icon of Webvue team medias. Input Icon Max Length : 100. 
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function add_post()
	{
		$this->is_allowed('api_webvue_team_media_add', false);

		$this->form_validation->set_rules('member_id', 'Member Id', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		$this->form_validation->set_rules('icon', 'Icon', 'trim|required|max_length[100]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'member_id' => $this->input->post('member_id'),
				'name' => $this->input->post('name'),
				'link' => $this->input->post('link'),
				'icon' => $this->input->post('icon'),
			];
			
			$save_webvue_team_media = $this->model_api_webvue_team_media->store($save_data);

			if ($save_webvue_team_media) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully stored into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}

	/**
	 * @api {post} /webvue_team_media/update Update Webvue team media.
	 * @apiVersion 0.1.0
	 * @apiName UpdateWebvue team media
	 * @apiGroup webvue_team_media
	 * @apiHeader {String} X-Api-Key Webvue team medias unique access-key.
	 * @apiPermission Webvue team media Cant be Accessed permission name : api_webvue_team_media_update
	 *
	 * @apiParam {String} Member_id Mandatory member_id of Webvue team medias. Input Member Id Max Length : 100. 
	 * @apiParam {String} Name Mandatory name of Webvue team medias. Input Name Max Length : 200. 
	 * @apiParam {String} Link Mandatory link of Webvue team medias.  
	 * @apiParam {String} Icon Mandatory icon of Webvue team medias. Input Icon Max Length : 100. 
	 * @apiParam {Integer} id Mandatory id of Webvue Team Media.
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function update_post()
	{
		$this->is_allowed('api_webvue_team_media_update', false);

		
		$this->form_validation->set_rules('member_id', 'Member Id', 'trim|required|max_length[100]');
		$this->form_validation->set_rules('name', 'Name', 'trim|required|max_length[200]');
		$this->form_validation->set_rules('link', 'Link', 'trim|required');
		$this->form_validation->set_rules('icon', 'Icon', 'trim|required|max_length[100]');
		
		if ($this->form_validation->run()) {

			$save_data = [
				'member_id' => $this->input->post('member_id'),
				'name' => $this->input->post('name'),
				'link' => $this->input->post('link'),
				'icon' => $this->input->post('icon'),
			];
			
			$save_webvue_team_media = $this->model_api_webvue_team_media->change($this->post('id'), $save_data);

			if ($save_webvue_team_media) {
				$this->response([
					'status' 	=> true,
					'message' 	=> 'Your data has been successfully updated into the database'
				], API::HTTP_OK);

			} else {
				$this->response([
					'status' 	=> false,
					'message' 	=> cclang('data_not_change')
				], API::HTTP_NOT_ACCEPTABLE);
			}

		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Validation Errors.',
				'errors' 	=> $this->form_validation->error_array()
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
	/**
	 * @api {post} /webvue_team_media/delete Delete Webvue team media. 
	 * @apiVersion 0.1.0
	 * @apiName DeleteWebvue team media
	 * @apiGroup webvue_team_media
	 * @apiHeader {String} X-Api-Key Webvue team medias unique access-key.
	 	 * @apiPermission Webvue team media Cant be Accessed permission name : api_webvue_team_media_delete
	 *
	 * @apiParam {Integer} Id Mandatory id of Webvue team medias .
	 *
	 * @apiSuccess {Boolean} Status status response api.
	 * @apiSuccess {String} Message message response api.
	 *
	 * @apiSuccessExample Success-Response:
	 *     HTTP/1.1 200 OK
	 *
	 * @apiError ValidationError Error validation.
	 *
	 * @apiErrorExample Error-Response:
	 *     HTTP/1.1 403 Not Acceptable
	 *
	 */
	public function delete_post()
	{
		$this->is_allowed('api_webvue_team_media_delete', false);

		$webvue_team_media = $this->model_api_webvue_team_media->find($this->post('id'));

		if (!$webvue_team_media) {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue team media not found'
			], API::HTTP_NOT_ACCEPTABLE);
		} else {
			$delete = $this->model_api_webvue_team_media->remove($this->post('id'));

			}
		
		if ($delete) {
			$this->response([
				'status' 	=> true,
				'message' 	=> 'Webvue team media deleted',
			], API::HTTP_OK);
		} else {
			$this->response([
				'status' 	=> false,
				'message' 	=> 'Webvue team media not delete'
			], API::HTTP_NOT_ACCEPTABLE);
		}
	}
	
}

/* End of file Webvue team media.php */
/* Location: ./application/controllers/api/Webvue team media.php */